/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.av;

import java.nio.ByteBuffer;
import jogamp.opengl.Debug;

public interface AudioSink {
    public static final boolean DEBUG = Debug.debug("AudioSink");
    public static final AudioDataFormat DefaultFormat = new AudioDataFormat(AudioDataType.PCM, 44100, 16, 2, true, true);

    public boolean isInitialized();

    public AudioDataFormat getPreferredFormat();

    public AudioDataFormat initSink(AudioDataFormat var1, int var2);

    public void destroy();

    public int getQueuedByteCount();

    public int getQueuedTime();

    public int getWritableBufferCount();

    public boolean isDataAvailable(int var1);

    public void writeData(AudioFrame var1);

    public static class AudioFrame {
        public final ByteBuffer data;
        public final int dataSize;
        public final int audioPTS;

        public AudioFrame(ByteBuffer byteBuffer, int n, int n2) {
            if (n > byteBuffer.remaining()) {
                throw new IllegalArgumentException("Give size " + n + " exceeds remaining bytes in ls " + byteBuffer + ". " + this);
            }
            this.data = byteBuffer;
            this.dataSize = n;
            this.audioPTS = n2;
        }

        public String toString() {
            return "AudioFrame[apts " + this.audioPTS + ", data " + this.data + ", payloadSize " + this.dataSize + "]";
        }
    }

    public static class AudioDataFormat {
        public final AudioDataType dataType;
        public final int sampleRate;
        public final int sampleSize;
        public final int channelCount;
        public final boolean signed;
        public final boolean littleEndian;

        public AudioDataFormat(AudioDataType audioDataType, int n, int n2, int n3, boolean bl, boolean bl2) {
            this.dataType = audioDataType;
            this.sampleRate = n;
            this.sampleSize = n2;
            this.channelCount = n3;
            this.signed = bl;
            this.littleEndian = bl2;
        }

        public String toString() {
            return "AudioDataFormat[type " + (Object)((Object)this.dataType) + ", sampleRate " + this.sampleRate + ", sampleSize " + this.sampleSize + ", channelCount " + this.channelCount + ", signed " + this.signed + ", " + (this.littleEndian ? "little" : "big") + "endian]";
        }
    }

    public static enum AudioDataType {
        PCM;

    }
}

