/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Waveform;
import java.util.Random;

public class Wavetable
implements Waveform {
    private float[] waveform;
    private float lengthForValue;

    public Wavetable(int n) {
        this.waveform = new float[n];
        this.lengthForValue = n - 1;
    }

    public Wavetable(float[] fArray) {
        this.waveform = fArray;
        this.lengthForValue = fArray.length - 1;
    }

    public Wavetable(Wavetable wavetable) {
        this.waveform = new float[wavetable.waveform.length];
        System.arraycopy(wavetable.waveform, 0, this.waveform, 0, this.waveform.length);
        this.lengthForValue = this.waveform.length - 1;
    }

    public void setWaveform(float[] fArray) {
        this.waveform = fArray;
        this.lengthForValue = fArray.length - 1;
    }

    public float get(int n) {
        return this.waveform[n];
    }

    @Override
    public float value(float f) {
        float f2 = this.lengthForValue * f;
        int n = (int)f2;
        int n2 = n + 1;
        if (n2 >= this.waveform.length) {
            n2 -= this.waveform.length;
        }
        float f3 = f2 - (float)n;
        return this.waveform[n] + f3 * (this.waveform[n2] - this.waveform[n]);
    }

    public float[] getWaveform() {
        return this.waveform;
    }

    public void set(int n, float f) {
        this.waveform[n] = f;
    }

    public int size() {
        return this.waveform.length;
    }

    public void scale(float f) {
        int n = 0;
        while (n < this.waveform.length) {
            int n2 = n++;
            this.waveform[n2] = this.waveform[n2] * f;
        }
    }

    public void offset(float f) {
        int n = 0;
        while (n < this.waveform.length) {
            int n2 = n++;
            this.waveform[n2] = this.waveform[n2] + f;
        }
    }

    public void normalize() {
        float f = Float.MIN_VALUE;
        for (int i = 0; i < this.waveform.length; ++i) {
            if (!(Math.abs(this.waveform[i]) > f)) continue;
            f = Math.abs(this.waveform[i]);
        }
        this.scale(1.0f / f);
    }

    public void invert() {
        this.flip(0.0f);
    }

    public void flip(float f) {
        for (int i = 0; i < this.waveform.length; ++i) {
            this.waveform[i] = this.waveform[i] > f ? f - (this.waveform[i] - f) : f + (f - this.waveform[i]);
        }
    }

    public void addNoise(float f) {
        Random random = new Random();
        int n = 0;
        while (n < this.waveform.length) {
            int n2 = n++;
            this.waveform[n2] = this.waveform[n2] + (float)random.nextGaussian() * f;
        }
    }

    public void rectify() {
        for (int i = 0; i < this.waveform.length; ++i) {
            if (!(this.waveform[i] < 0.0f)) continue;
            int n = i;
            this.waveform[n] = this.waveform[n] * -1.0f;
        }
    }

    public void smooth(int n) {
        if (n < 1) {
            return;
        }
        float[] fArray = (float[])this.waveform.clone();
        for (int i = n; i < this.waveform.length; ++i) {
            float f = 0.0f;
            for (int j = i - n; j <= i; ++j) {
                f += fArray[j] / (float)n;
            }
            this.waveform[i] = f;
        }
    }
}

