/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.ugens.Wavetable;
import ddf.minim.ugens.WavetableGenerator;

public class Waves {
    private static int tableSize = 8192;
    private static int tSby2 = tableSize / 2;
    private static int tSby4 = tableSize / 4;
    public static final Wavetable SINE = WavetableGenerator.gen10(tableSize, new float[]{1.0f});
    public static final Wavetable SAW = WavetableGenerator.gen7(tableSize, new float[]{0.0f, -1.0f, 1.0f, 0.0f}, new int[]{tSby2, 0, tableSize - tSby2});
    public static final Wavetable PHASOR = WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f}, new int[]{tableSize});
    public static final Wavetable SQUARE = WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, new int[]{tSby2, 0, tableSize - tSby2});
    public static final Wavetable TRIANGLE = WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f, -1.0f, 0.0f}, new int[]{tSby4, tSby2, tableSize - tSby2 - tSby4});
    public static final Wavetable QUARTERPULSE = WavetableGenerator.gen7(tableSize, new float[]{-1.0f, -1.0f, 1.0f, 1.0f}, new int[]{tSby4, 0, tableSize - tSby4});

    public static Wavetable saw(int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)(-2.0 / ((double)(i + 1) * Math.PI) * Math.pow(-1.0, i + 1));
        }
        return WavetableGenerator.gen10(tableSize, fArray);
    }

    public static Wavetable square(int n) {
        float[] fArray = new float[n + 1];
        for (int i = 0; i < n; i += 2) {
            fArray[i] = 1.0f / (float)(i + 1);
            fArray[i + 1] = 0.0f;
        }
        return WavetableGenerator.gen10(tableSize, fArray);
    }

    public static Wavetable triangle(int n) {
        float[] fArray = new float[n + 1];
        for (int i = 0; i < n; i += 2) {
            fArray[i] = (float)(Math.pow(-1.0, i / 2) * 8.0 / Math.PI / Math.PI / Math.pow(i + 1, 2.0));
            fArray[i + 1] = 0.0f;
        }
        return WavetableGenerator.gen10(tableSize, fArray);
    }

    public static Wavetable pulse(float f) {
        return WavetableGenerator.gen7(tableSize, new float[]{1.0f, 1.0f, -1.0f, -1.0f}, new int[]{(int)(f * (float)tableSize), 0, tableSize - (int)(f * (float)tableSize)});
    }

    public static Wavetable triangle(float f) {
        int n = (int)((double)((float)tableSize * f) * 0.5);
        return WavetableGenerator.gen7(tableSize, new float[]{0.0f, 1.0f, 0.0f, -1.0f, 0.0f}, new int[]{n, n, tSby2 - n, tableSize - tSby2 - n});
    }

    public static Wavetable saw(float f) {
        int n = (int)((float)tableSize * f);
        return WavetableGenerator.gen7(tableSize, new float[]{1.0f, 0.0f, -1.0f}, new int[]{n, tableSize - n});
    }

    public static Wavetable square(float f) {
        return Waves.pulse(f);
    }

    public static Wavetable randomNHarms(int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)Math.random() * 2.0f - 1.0f;
        }
        Wavetable wavetable = WavetableGenerator.gen10(tableSize, fArray);
        wavetable.normalize();
        return wavetable;
    }

    public static Wavetable randomNOddHarms(int n) {
        float[] fArray = new float[n * 2];
        for (int i = 0; i < n; ++i) {
            fArray[i * 2] = (float)Math.random() * 2.0f - 1.0f;
            fArray[i * 2 + 1] = 0.0f;
        }
        Wavetable wavetable = WavetableGenerator.gen10(tableSize, fArray);
        wavetable.normalize();
        return wavetable;
    }

    public static Wavetable randomNoise() {
        float[] fArray = new float[tableSize];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)Math.random() * 2.0f - 1.0f;
        }
        Wavetable wavetable = new Wavetable(fArray);
        wavetable.normalize();
        return wavetable;
    }

    public static Wavetable add(float[] fArray, Wavetable ... wavetableArray) {
        if (fArray.length != wavetableArray.length) {
            System.out.println("add() : amplitude array size must match the number of waveforms...");
            System.out.println("...returning the first waveform ");
            return wavetableArray[0];
        }
        float[] fArray2 = new float[tableSize];
        for (int i = 0; i < wavetableArray.length; ++i) {
            wavetableArray[i].scale(fArray[i]);
            for (int j = 0; j < tableSize; ++j) {
                int n = j;
                fArray2[n] = fArray2[n] + wavetableArray[i].get(j);
            }
        }
        return new Wavetable(fArray2);
    }
}

