/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.Minim;
import ddf.minim.analysis.FourierTransform;

public class FFT
extends FourierTransform {
    private int[] reverse;
    private float[] sinlookup;
    private float[] coslookup;

    public FFT(int n, float f) {
        super(n, f);
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException("FFT: timeSize must be a power of two.");
        }
        this.buildReverseTable();
        this.buildTrigTables();
    }

    @Override
    protected void allocateArrays() {
        this.spectrum = new float[this.timeSize / 2 + 1];
        this.real = new float[this.timeSize];
        this.imag = new float[this.timeSize];
    }

    @Override
    public void scaleBand(int n, float f) {
        if (f < 0.0f) {
            Minim.error("Can't scale a frequency band by a negative value.");
            return;
        }
        int n2 = n;
        this.real[n2] = this.real[n2] * f;
        int n3 = n;
        this.imag[n3] = this.imag[n3] * f;
        int n4 = n;
        this.spectrum[n4] = this.spectrum[n4] * f;
        if (n != 0 && n != this.timeSize / 2) {
            this.real[this.timeSize - n] = this.real[n];
            this.imag[this.timeSize - n] = -this.imag[n];
        }
    }

    @Override
    public void setBand(int n, float f) {
        if (f < 0.0f) {
            Minim.error("Can't set a frequency band to a negative value.");
            return;
        }
        if (this.real[n] == 0.0f && this.imag[n] == 0.0f) {
            this.real[n] = f;
            this.spectrum[n] = f;
        } else {
            int n2 = n;
            this.real[n2] = this.real[n2] / this.spectrum[n];
            int n3 = n;
            this.imag[n3] = this.imag[n3] / this.spectrum[n];
            this.spectrum[n] = f;
            int n4 = n;
            this.real[n4] = this.real[n4] * this.spectrum[n];
            int n5 = n;
            this.imag[n5] = this.imag[n5] * this.spectrum[n];
        }
        if (n != 0 && n != this.timeSize / 2) {
            this.real[this.timeSize - n] = this.real[n];
            this.imag[this.timeSize - n] = -this.imag[n];
        }
    }

    private void fft() {
        for (int i = 1; i < this.real.length; i *= 2) {
            float f = this.cos(i);
            float f2 = this.sin(i);
            float f3 = 1.0f;
            float f4 = 0.0f;
            for (int j = 0; j < i; ++j) {
                for (int k = j; k < this.real.length; k += 2 * i) {
                    int n = k + i;
                    float f5 = f3 * this.real[n] - f4 * this.imag[n];
                    float f6 = f3 * this.imag[n] + f4 * this.real[n];
                    this.real[n] = this.real[k] - f5;
                    this.imag[n] = this.imag[k] - f6;
                    int n2 = k;
                    this.real[n2] = this.real[n2] + f5;
                    int n3 = k;
                    this.imag[n3] = this.imag[n3] + f6;
                }
                float f7 = f3;
                f3 = f7 * f - f4 * f2;
                f4 = f7 * f2 + f4 * f;
            }
        }
    }

    @Override
    public void forward(float[] fArray) {
        if (fArray.length != this.timeSize) {
            Minim.error("FFT.forward: The length of the passed sample buffer must be equal to timeSize().");
            return;
        }
        this.doWindow(fArray);
        this.bitReverseSamples(fArray, 0);
        this.fft();
        this.fillSpectrum();
    }

    @Override
    public void forward(float[] fArray, int n) {
        if (fArray.length - n < this.timeSize) {
            Minim.error("FourierTransform.forward: not enough samples in the buffer between " + n + " and " + fArray.length + " to perform a transform.");
            return;
        }
        this.windowFunction.apply(fArray, n, this.timeSize);
        this.bitReverseSamples(fArray, n);
        this.fft();
        this.fillSpectrum();
    }

    public void forward(float[] fArray, float[] fArray2) {
        if (fArray.length != this.timeSize || fArray2.length != this.timeSize) {
            Minim.error("FFT.forward: The length of the passed buffers must be equal to timeSize().");
            return;
        }
        this.setComplex(fArray, fArray2);
        this.bitReverseComplex();
        this.fft();
        this.fillSpectrum();
    }

    @Override
    public void inverse(float[] fArray) {
        if (fArray.length > this.real.length) {
            Minim.error("FFT.inverse: the passed array's length must equal FFT.timeSize().");
            return;
        }
        int n = 0;
        while (n < this.timeSize) {
            int n2 = n++;
            this.imag[n2] = this.imag[n2] * -1.0f;
        }
        this.bitReverseComplex();
        this.fft();
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = this.real[n] / (float)this.real.length;
        }
    }

    private void buildReverseTable() {
        int n = this.timeSize;
        this.reverse = new int[n];
        this.reverse[0] = 0;
        int n2 = 1;
        int n3 = n / 2;
        while (n2 < n) {
            for (int i = 0; i < n2; ++i) {
                this.reverse[i + n2] = this.reverse[i] + n3;
            }
            n2 <<= 1;
            n3 >>= 1;
        }
    }

    private void bitReverseSamples(float[] fArray, int n) {
        for (int i = 0; i < this.timeSize; ++i) {
            this.real[i] = fArray[n + this.reverse[i]];
            this.imag[i] = 0.0f;
        }
    }

    private void bitReverseComplex() {
        float[] fArray = new float[this.real.length];
        float[] fArray2 = new float[this.imag.length];
        for (int i = 0; i < this.real.length; ++i) {
            fArray[i] = this.real[this.reverse[i]];
            fArray2[i] = this.imag[this.reverse[i]];
        }
        this.real = fArray;
        this.imag = fArray2;
    }

    private float sin(int n) {
        return this.sinlookup[n];
    }

    private float cos(int n) {
        return this.coslookup[n];
    }

    private void buildTrigTables() {
        int n = this.timeSize;
        this.sinlookup = new float[n];
        this.coslookup = new float[n];
        for (int i = 0; i < n; ++i) {
            this.sinlookup[i] = (float)Math.sin((float)(-Math.PI) / (float)i);
            this.coslookup[i] = (float)Math.cos((float)(-Math.PI) / (float)i);
        }
    }
}

