/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.Minim;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;

public class Controller {
    public static FloatControl.Type VOLUME = FloatControl.Type.VOLUME;
    public static FloatControl.Type GAIN = FloatControl.Type.MASTER_GAIN;
    public static FloatControl.Type BALANCE = FloatControl.Type.BALANCE;
    public static FloatControl.Type PAN = FloatControl.Type.PAN;
    public static FloatControl.Type SAMPLE_RATE = FloatControl.Type.SAMPLE_RATE;
    public static BooleanControl.Type MUTE = BooleanControl.Type.MUTE;
    private Control[] controls;
    private ValueShifter vshifter;
    private ValueShifter gshifter;
    private ValueShifter bshifter;
    private ValueShifter pshifter;
    private boolean vshift;
    private boolean gshift;
    private boolean bshift;
    private boolean pshift;

    public Controller(Control[] controlArray) {
        this.controls = controlArray;
        this.pshift = false;
        this.bshift = false;
        this.gshift = false;
        this.vshift = false;
    }

    void update() {
        if (this.vshift) {
            this.setVolume(this.vshifter.value());
            if (this.vshifter.done()) {
                this.vshift = false;
            }
        }
        if (this.gshift) {
            this.setGain(this.gshifter.value());
            if (this.gshifter.done()) {
                this.gshift = false;
            }
        }
        if (this.bshift) {
            this.setBalance(this.bshifter.value());
            if (this.bshifter.done()) {
                this.bshift = false;
            }
        }
        if (this.pshift) {
            this.setPan(this.pshifter.value());
            if (this.pshifter.done()) {
                this.pshift = false;
            }
        }
    }

    public void printControls() {
        if (this.controls.length > 0) {
            System.out.println("Available controls are:");
            for (int i = 0; i < this.controls.length; ++i) {
                Control.Type type = this.controls[i].getType();
                System.out.print("  " + type.toString());
                if (type == VOLUME || type == GAIN || type == BALANCE || type == PAN) {
                    FloatControl floatControl = (FloatControl)this.controls[i];
                    String string = "does";
                    if (floatControl.getUpdatePeriod() == -1) {
                        string = "doesn't";
                    }
                    System.out.println(", which has a range of " + floatControl.getMaximum() + " to " + floatControl.getMinimum() + " and " + string + " support shifting.");
                    continue;
                }
                System.out.println("");
            }
        } else {
            System.out.println("There are no controls available for this line.");
        }
    }

    public boolean hasControl(Control.Type type) {
        for (int i = 0; i < this.controls.length; ++i) {
            if (!this.controls[i].getType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public Control[] getControls() {
        return this.controls;
    }

    public Control getControl(Control.Type type) {
        for (int i = 0; i < this.controls.length; ++i) {
            if (!this.controls[i].getType().equals(type)) continue;
            return this.controls[i];
        }
        return null;
    }

    public FloatControl volume() {
        return (FloatControl)this.getControl(VOLUME);
    }

    public FloatControl gain() {
        return (FloatControl)this.getControl(GAIN);
    }

    public FloatControl balance() {
        return (FloatControl)this.getControl(BALANCE);
    }

    public FloatControl pan() {
        return (FloatControl)this.getControl(PAN);
    }

    public void mute() {
        this.setValue(MUTE, true);
    }

    public void unmute() {
        this.setValue(MUTE, false);
    }

    public boolean isMuted() {
        return this.getValue(MUTE);
    }

    private boolean getValue(BooleanControl.Type type) {
        boolean bl = false;
        if (this.hasControl(type)) {
            BooleanControl booleanControl = (BooleanControl)this.getControl(type);
            bl = booleanControl.getValue();
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
        return bl;
    }

    private void setValue(BooleanControl.Type type, boolean bl) {
        if (this.hasControl(type)) {
            BooleanControl booleanControl = (BooleanControl)this.getControl(type);
            booleanControl.setValue(bl);
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
    }

    private float getValue(FloatControl.Type type) {
        float f = 0.0f;
        if (this.hasControl(type)) {
            FloatControl floatControl = (FloatControl)this.getControl(type);
            f = floatControl.getValue();
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
        return f;
    }

    private void setValue(FloatControl.Type type, float f) {
        if (this.hasControl(type)) {
            FloatControl floatControl = (FloatControl)this.getControl(type);
            if (f > floatControl.getMaximum()) {
                f = floatControl.getMaximum();
            } else if (f < floatControl.getMinimum()) {
                f = floatControl.getMinimum();
            }
            floatControl.setValue(f);
        } else {
            Minim.error(type.toString() + " is not supported.");
        }
    }

    public float getVolume() {
        return this.getValue(VOLUME);
    }

    public void setVolume(float f) {
        this.setValue(VOLUME, f);
    }

    public void shiftVolume(float f, float f2, int n) {
        if (this.hasControl(VOLUME)) {
            this.setVolume(f);
            this.vshifter = new ValueShifter(f, f2, n);
            this.vshift = true;
        }
    }

    public float getGain() {
        return this.getValue(GAIN);
    }

    public void setGain(float f) {
        this.setValue(GAIN, f);
    }

    public void shiftGain(float f, float f2, int n) {
        if (this.hasControl(GAIN)) {
            this.setGain(f);
            this.gshifter = new ValueShifter(f, f2, n);
            this.gshift = true;
        }
    }

    public float getBalance() {
        return this.getValue(BALANCE);
    }

    public void setBalance(float f) {
        this.setValue(BALANCE, f);
    }

    public void shiftBalance(float f, float f2, int n) {
        if (this.hasControl(BALANCE)) {
            this.setBalance(f);
            this.bshifter = new ValueShifter(f, f2, n);
            this.bshift = true;
        }
    }

    public float getPan() {
        return this.getValue(PAN);
    }

    public void setPan(float f) {
        this.setValue(PAN, f);
    }

    public void shiftPan(float f, float f2, int n) {
        if (this.hasControl(PAN)) {
            this.setPan(f);
            this.pshifter = new ValueShifter(f, f2, n);
            this.pshift = true;
        }
    }

    class ValueShifter {
        private float tstart = (int)System.currentTimeMillis();
        private float tend;
        private float vstart;
        private float vend;

        public ValueShifter(float f, float f2, int n) {
            this.tend = this.tstart + (float)n;
            this.vstart = f;
            this.vend = f2;
        }

        public float value() {
            int n = (int)System.currentTimeMillis();
            float f = ((float)n - this.tstart) / (this.tend - this.tstart);
            float f2 = this.vend - this.vstart;
            return this.vstart + f2 * f;
        }

        public boolean done() {
            return (float)((int)System.currentTimeMillis()) > this.tend;
        }
    }
}

