// shader.h

struct Texture;

class Shader {
private:

  ID3DXEffect* m_pEffect;
  std::string m_shaderFileName;
  FILETIME m_shaderFileLastWriteTime;

public:
  Shader();
  ~Shader();

  bool CreateFromFile(LPDIRECT3DDEVICE9 pDev9, std::string fileName);

  bool SetTexture(const char *shaderName, Texture *pTexture);

  ID3DXEffect *GetEffect() { return m_pEffect; }

  bool Enable(const char *technique = "Render");
  bool Flush();
  bool Disable();

  bool CheckModifiedOnDisk();

};
