// music.h

class Music {
private:
  bool m_musicSystemAdded;

  FMOD_SYSTEM *m_fModSystem;

  FMOD_SOUND *m_fModSoundMusic;
  FMOD_CHANNEL *m_fModChannelMusic;
  int m_musicLength;
  bool m_musicLoaded;

  bool m_bMusicPaused;

public:
  Music();
  ~Music();

  void SetPause(bool paused);
  bool IsPlaying();
  void SetPosition(float t);
  float GetPosition();

  bool LoadSong(string fileName);

  void GetMusicSpectrum(float *spectrumArray, FMOD_DSP_FFT_WINDOW windowType=FMOD_DSP_FFT_WINDOW_HANNING, int numValues=1024, int channeloffset=0);
  void SetVolume(float v);
};