
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>


#include "string"

using std::string;

#include "fmod.h"

#include "datafile.h"

#include "music.h"

#include "common_globals.h"


Music::Music() {
  m_musicSystemAdded = false;
  m_musicLength = 0;
  m_musicLoaded = false;
}

Music::~Music() {

}


void Music::GetMusicSpectrum(float *spectrumArray, FMOD_DSP_FFT_WINDOW windowType, int numValues, int channeloffset) {
  FMOD_System_GetSpectrum(m_fModSystem, spectrumArray, numValues, channeloffset, windowType);
}

void Music::SetVolume(float v) {
    FMOD_Channel_SetVolume(m_fModChannelMusic, v);
}

bool Music::LoadSong(string fileName) {


   InsertLoadedFileMusic(fileName);


// add the fmod music system
  if (!m_musicSystemAdded) {
    FMOD_RESULT result;

    result = FMOD_System_Create(&m_fModSystem);		// Create the main system object.
    if (result != FMOD_OK) {
    }

    result = FMOD_System_Init(m_fModSystem, 10, FMOD_INIT_NORMAL, 0);	// Initialize FMOD.
    if (result != FMOD_OK) {
    }
    m_musicSystemAdded = true;
  }

// add music to the music system

  FMOD_RESULT result;

  // FMOD_CREATECOMPRESSEDSAMPLE tells the sample to attempt playing it as it is, without decompressing it into memory first.  This is only supported for IMA ADPCM, MP2, MP3 and XMA audio formats.
  //result = FMOD_System_CreateSound(this->fModSystem, fileName.c_str(), FMOD_CREATECOMPRESSEDSAMPLE, 0, &this->fModSound);

  // This is needed for DSP effects and for Spectrum analysis
  // FMOD_DEFAULT
  // FMOD_ACCURATETIME
  // FMOD_SOFTWARE
//   result = FMOD_System_CreateSound(this->fModSystem, fileName.c_str(), FMOD_SOFTWARE | FMOD_CREATESTREAM, 0, &this->fModSoundMusic);
//   result = FMOD_System_CreateSound(fModSystem, "./datsun/koepala.mp3", FMOD_HARDWARE | FMOD_CREATESTREAM, 0, &fModSoundMusic);


// FMOD_OPENMEMORY

//  result = FMOD_System_CreateSound(fModSystem, "./datsun/koepala.mp3", FMOD_SOFTWARE | FMOD_CREATESTREAM, 0, &fModSoundMusic);

  char *musaData = NULL;
  unsigned int musaKoko = 0;

  if (getData(fileName.c_str(), NULL, &musaKoko, &musaData)) {

    FMOD_CREATESOUNDEXINFO fmodSexInfo;
    memset(&fmodSexInfo, 0, sizeof(FMOD_CREATESOUNDEXINFO));
    fmodSexInfo.cbsize = sizeof(FMOD_CREATESOUNDEXINFO);
    fmodSexInfo.length = musaKoko;
    /*
    fmodSexInfo.fileoffset = 0;
    fmodSexInfo.numchannels = 0;
    fmodSexInfo.defaultfrequency = 0;
    fmodSexInfo.format = FMOD_SOUND_FORMAT_NONE;
    fmodSexInfo.decodebuffersize = 0;
    fmodSexInfo.initialsubsound = 0;
    fmodSexInfo.numsubsounds = 0;
    fmodSexInfo.inclusionlist = 0;
    fmodSexInfo.inclusionlistnum = 0;
    fmodSexInfo.pcmreadcallback = 0;
    fmodSexInfo.pcmsetposcallback = 0;
    fmodSexInfo.nonblockcallback = 0;
    fmodSexInfo.dlsname = 0;
    fmodSexInfo.encryptionkey = 0;
    fmodSexInfo.maxpolyphony = 0;
    fmodSexInfo.userdata = 0;
    fmodSexInfo.suggestedsoundtype = FMOD_SOUND_TYPE_UNKNOWN;
    fmodSexInfo.useropen = 0;
    fmodSexInfo.userclose = 0;
    fmodSexInfo.userread = 0;
    fmodSexInfo.userseek = 0;
    */

    result = FMOD_System_CreateSound(m_fModSystem, musaData, FMOD_SOFTWARE | FMOD_HARDWARE*0 | FMOD_OPENMEMORY | FMOD_CREATESTREAM | FMOD_ACCURATETIME, &fmodSexInfo, &m_fModSoundMusic);

    m_musicLoaded = true;
  }



//   result = FMOD_System_CreateSound(this->fModSystem, fileName.c_str(), FMOD_SOFTWARE, 0, &this->fModSoundMusic);
//  result = FMOD_System_CreateSound(this->fModSystem, fileName.c_str(), FMOD_DEFAULT, 0, &this->fModSoundMusic);
  if (result != FMOD_OK) {
      return 0;
  }

  // start playing a sound in a pause mode
  result = FMOD_System_PlaySound(m_fModSystem, FMOD_CHANNEL_FREE, m_fModSoundMusic, true, &m_fModChannelMusic);
  if (result != FMOD_OK) {
      return 0;
  }

  m_bMusicPaused = true;

  unsigned int musicLen;
  FMOD_Sound_GetLength(m_fModSoundMusic, &musicLen, FMOD_TIMEUNIT_MS);
  m_musicLength = musicLen;


// start playing the music
/*
  if (m_musicLoaded) {
      FMOD_RESULT result;
      result = FMOD_Channel_SetPaused(m_fModChannelMusic, true);
      if (result != FMOD_OK) {
      }
  } else {
   //   this->timer.start();
  }
  */

  return 1;

}

void Music::SetPause(bool paused) {
  if (m_musicLoaded) {
    FMOD_RESULT result;
    m_bMusicPaused = paused;
    if (paused) {
      result = FMOD_Channel_SetPaused(m_fModChannelMusic, true);
    } else {
      result = FMOD_Channel_SetPaused(m_fModChannelMusic, false);
    }
    if (result != FMOD_OK) {
    }
  }
}


bool Music::IsPlaying() {
  if (m_musicLoaded) {
    FMOD_BOOL isPlaying;
    FMOD_Channel_IsPlaying(m_fModChannelMusic, &isPlaying);
    return isPlaying && !m_bMusicPaused;
  }
  return 0;
}


void Music::SetPosition(float t) {
  if (m_musicLoaded) {
    FMOD_Channel_SetPosition(m_fModChannelMusic, (unsigned int)(t*1000.0f), FMOD_TIMEUNIT_MS);
  }
}

float Music::GetPosition() {
  if (m_musicLoaded) {
    unsigned int posResult = 0;
    FMOD_Channel_GetPosition(m_fModChannelMusic, &posResult, FMOD_TIMEUNIT_MS);
    return (float)posResult/1000.0f;
  }
  return 0.0f;
}
