// deferred.cpp

#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <map>

using std::string;
using std::vector;
using std::list;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "shader.h"
#include "deferred.h"

static Deferred *s_deferred = NULL;

Deferred* GetDeferred() {
  if (s_deferred)
    return s_deferred;

  s_deferred = new Deferred();
  s_deferred->Init();
  return s_deferred;
}

Deferred::Deferred() {
  m_materialDiffuse = D3DXVECTOR4(1.0f, 1.0f, 1.0f, 1.0f);
  m_mrtDeferred = NULL;
  m_bRenderOnlyDepth = false;
}


Deferred::~Deferred() {
}

bool Deferred::Init() {
  bool success = true;

//  m_rt16b_depth = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_depth", 0, D3DFMT_R32F); // D3DFMT_R16F, D3DFMT_R32F
//  m_rt16b_normal = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_normal", 0); // , D3DFMT_A16B16G16R16F);
//  m_rt16b_diffuse = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_diffuse", 0);//, D3DFMT_A16B16G16R16F);

  m_rt16b_depth = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth*1, g_D3DApp->m_windowHeight*1, "rt16b_depth", 0, D3DFMT_G32R32F); // D3DFMT_G32R32F  D3DFMT_R16F, D3DFMT_R32F  D3DFMT_G32R32F
  m_rt16b_normal = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth*1, g_D3DApp->m_windowHeight*1, "rt16b_normal", 0, D3DFMT_A16B16G16R16F); //D3DFMT_A32B32G32R32F);
 // if (!m_rt16b_normal) {
 //   m_rt16b_normal = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_normal", 0);
 // }
  m_rt16b_diffuse = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth*1, g_D3DApp->m_windowHeight*1, "rt16b_diffuse", 0, D3DFMT_A16B16G16R16F); //D3DFMT_A32B32G32R32F);
  m_rt16b_ambspec = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth*1, g_D3DApp->m_windowHeight*1, "rt16b_ambspec", 0, D3DFMT_A16B16G16R16F);


  ReloadShaders();
  return success;
}

void Deferred::ReloadShaders() {
  /*
  if (m_mrtDeferred) {
    delete m_mrtDeferred;
  }
  */
  if (!m_mrtDeferred) {
    m_mrtDeferred = new Shader();
  }
  m_mrtDeferred->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/mrt_deferred.h");
}


bool Deferred::CheckShadersModifiedOnDisk() {
  if (m_mrtDeferred && m_mrtDeferred->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}


void Deferred::SetMaterial(const D3DMATERIAL9 *pMaterial) {
  m_materialDiffuse = D3DXVECTOR4(pMaterial->Diffuse.r, pMaterial->Diffuse.g, pMaterial->Diffuse.b, pMaterial->Diffuse.a);
  m_mrtDeferred->GetEffect()->SetVector( "g_materialDiffuse", &m_materialDiffuse );
}

void Deferred::SetTexture(LPDIRECT3DTEXTURE9 lpTex) {
  m_mrtDeferred->GetEffect()->SetTexture( "g_tDiffuse", lpTex );
}

bool Deferred::BeginDraw(bool clear) {
  bool success = true;
  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;
  
  clear = false;

  g_D3DApp->setRenderTarget(m_rt16b_depth, 0);
  if (clear)
    pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(255, 255, 255, 255), 1.0f, 0 );
 // g_D3DApp->resetRenderTarget();
  if (m_bRenderOnlyDepth) {
   // Texture *pTemp = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth*1, g_D3DApp->m_windowHeight*1, "rt16b_temp_null", 0, D3DFMT_A16B16G16R16F); //D3DFMT_A32B32G32R32F);
   // g_D3DApp->setRenderTarget(pTemp, 1);
   // g_D3DApp->setRenderTarget(pTemp, 2);
   // g_D3DApp->setRenderTarget(pTemp, 3);
  g_D3DApp->m_pd3dDevice->SetRenderTarget(1, 0);
  g_D3DApp->m_pd3dDevice->SetRenderTarget(2, 0);
  g_D3DApp->m_pd3dDevice->SetRenderTarget(3, 0);

    return true;
  }
  g_D3DApp->setRenderTarget(m_rt16b_normal, 1);
  if (clear)
    pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(127, 127, 127, 0), 1.0f, 0 );

  g_D3DApp->setRenderTarget(m_rt16b_diffuse, 2);
  if (clear)
    pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(0,0,0,0), 1.0f, 0 );

  g_D3DApp->setRenderTarget(m_rt16b_ambspec, 3);
  if (clear)
    pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(0,64,0,0), 1.0f, 0 );
  
  return success;
}

bool Deferred::EndDraw() {
  bool success = true;

  g_D3DApp->m_pd3dDevice->SetRenderTarget(1, 0);
  g_D3DApp->m_pd3dDevice->SetRenderTarget(2, 0);
  g_D3DApp->m_pd3dDevice->SetRenderTarget(3, 0);

  g_D3DApp->resetRenderTarget();
  return success;
}



bool Deferred::SetView(D3DXMATRIXA16 *matView) {
  bool success = true;
  m_matView = *matView;
  m_mrtDeferred->GetEffect()->SetMatrix( "g_mView", &m_matView );
  return success;
}

bool Deferred::SetInvView(D3DXMATRIXA16 *matInvView) {
  bool success = true;
  m_matInvView = *matInvView;
  m_mrtDeferred->GetEffect()->SetMatrix( "g_mInvView", &m_matInvView );
  return success;
}

bool Deferred::SetWorld(D3DXMATRIXA16 *matWorld) {
  bool success = true;
  m_matWorld = *matWorld;
  m_mrtDeferred->GetEffect()->SetMatrix( "g_mWorld", &m_matWorld );
  return success;
}

bool Deferred::SetProj(D3DXMATRIXA16 *matProj)
{
  bool success = true;
  m_matProj = *matProj;
  m_mrtDeferred->GetEffect()->SetMatrix( "g_mProj", &m_matProj );
  return success;
}

bool Deferred::SetWVP(D3DXMATRIXA16 *matWVP) {
  bool success = true;
  m_matWVP = *matWVP;
  m_mrtDeferred->GetEffect()->SetMatrix( "g_mWorldViewProjection", &m_matWVP );
  return success;
}

bool Deferred::SetWVP(D3DXMATRIXA16 *matWorld, D3DXMATRIXA16 *matView, D3DXMATRIXA16 *matProj) {
  bool success = true;
  m_matWVP = (*matWorld)*(*matView)*(*matProj);
  m_matWorld = *matWorld;
  m_matView = *matView;
  m_mrtDeferred->GetEffect()->SetMatrix( "g_mWorldViewProjection", &m_matWVP );
  return success;
}

bool Deferred::BeginShader(const char *tech) {
  bool success = true;

  if (tech)
    m_activeShader = tech;
  else
    m_activeShader = "bump";

  m_mrtDeferred->Enable(m_activeShader.c_str());
  return success;
}

bool Deferred::FlushShader() {
  return m_mrtDeferred->Flush();
}

bool Deferred::BeginShaderDiffuseOnly() {
  bool success = true;
  m_mrtDeferred->GetEffect()->SetVector( "g_materialDiffuse", &m_materialDiffuse );
  g_D3DApp->m_pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  g_D3DApp->m_pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  m_mrtDeferred->Enable("RenderDiffuse");
  return success;
}


bool Deferred::EndShader() {
  bool success = true;
  m_mrtDeferred->Disable();
  return success;
}







