#include "windows.h"
#include "datafile.h"

std::vector<std::string> filesLoaded;

int getData(const char *filename, unsigned char **data, unsigned int *filesize, char **dataC) {


  FILE *f;
  char sana[256];
  int dataReadSuccess = 0;

  int fileLoaded=0;
  std::vector<std::string>::iterator ite;
  ite = filesLoaded.begin();
  while (ite != filesLoaded.end()) {
    if (strcmp((*ite).c_str(), filename)==0) {
      fileLoaded=1;
    }
    ite++;
  }
  if (!fileLoaded) {
    filesLoaded.push_back(filename);
  }

  if (data != NULL) {
    if ((*data) != NULL) {
      delete [] (*data);
    }

    (*data) = NULL;
  }

  if (dataC != NULL) {

    if ((*dataC) != NULL) {
      delete [] (*dataC);
    }
    (*dataC) = NULL;
  }

  if (!dataReadSuccess) {

    // no datapack.dat file found or the datafile wasn't in that file
    // try to load data from the original file

    f = NULL;
    f = fopen(filename, "rb");

    if (f != NULL) {

      fseek(f, 0, SEEK_END);
      (*filesize) = ftell(f);
      fseek(f, 0, SEEK_SET);


      size_t readAmount=0;
      size_t bytesToRead=(*filesize);

      if (dataC != NULL) {
        *dataC = new char[(*filesize)*2];
        while ((readAmount = fread((*dataC),1, bytesToRead, f)) != 0) {
          bytesToRead -= readAmount;
        }
      } else {
        *data = new unsigned char[(*filesize)*2];
        while ((readAmount = fread((*data),1, bytesToRead, f)) != 0) {
          bytesToRead -= readAmount;
        }
      }


      dataReadSuccess = 1;
      
      fclose(f);

      return 2;
    }
  }

  if (!dataReadSuccess) {

    f = fopen("datapack.dat", "rb");

    int readingState=0;
    if (f != NULL) {

      int luku=0;
      do {
        int sanaIndex=0;
        do {
          luku = fgetc(f);
          if (luku != EOF) {
            sana[sanaIndex] = luku;
            sanaIndex++;
            sana[sanaIndex] = 0;
          }
        } while ((luku != 0) && (luku != EOF));

        // read the length of the data
        (*filesize)=0;
        fread(filesize, 4, 1, f);

        if (strstr(sana, filename)) {
          dataReadSuccess = 1;
          break;
        } else {
          fseek(f, (*filesize), SEEK_CUR);
        }
      } while (luku != EOF);

      if (dataReadSuccess) {
        size_t readAmount=0;
        size_t bytesToRead=(*filesize);

        if (dataC != NULL) {
          *dataC = new char[(*filesize)];
          while ((readAmount = fread((*dataC),1, bytesToRead, f)) != 0) {
            bytesToRead -= readAmount;
          }
        } else {
          *data = new unsigned char[(*filesize)];
          while ((readAmount = fread((*data),1, bytesToRead, f)) != 0) {
            bytesToRead -= readAmount;
          }
        }
      }


/*
    // reverse the bytes

      if (dataC != NULL) {
        for (int i=0; i<(*filesize); i++) {
          unsigned char k,a;
          a = (*dataC)[i];

          k = ((a&1)<<7) + ((a&2)<<6) + ((a&4)<<5) + ((a&8)<<4) + ((a&16)<<3) + ((a&32)<<2) + ((a&64)<<1) + ((a&128)<<0);

          (*dataC)[i] = k;

          
        }
      } else {
        for (int i=0; i<(*filesize); i++) {
          unsigned char k,a;
          a = (*data)[i];

          k = ((a&1)<<7) + ((a&2)<<6) + ((a&4)<<5) + ((a&8)<<4) + ((a&16)<<3) + ((a&32)<<2) + ((a&64)<<1) + ((a&128)<<0);

          (*data)[i] = k;

          
        }
      }
      */


      fclose(f);

      return 1;

    }

  }

  if (!dataReadSuccess) {
      sprintf_s(sana, "Error: datafile %s not found.\n", filename);
      MessageBox(NULL, sana, ERROR, MB_ICONERROR | MB_OK);
      return 0;
  }

  return 0;
}
