
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <string>

#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "deferred.h"

#include "EffectLayout.h"

#include "mesh.h"

#include "effect.h"
#include "EffectCamera.h"
#include "effectMato.h"

// #include "EffectMeshView.h"


void EffectMato::Init() {
}

void EffectMato::Advance() {
}


static void BuildReplaceList(std::list<MeshReplace> *replaceList, const EffectParam *ep, string uniqueID, float effectTime) {
  int meshReplaceNum = ep->getN("replace");
  for (int mR=0; mR<meshReplaceNum; mR++) {
    MeshReplace meshReplace;

    const EffectParam *epr = ep->get("replace", mR);
    const EffectParam *eprm = epr->get("mesh");

    meshReplace.needle = epr->getString("needle");
    meshReplace.position = eprm->getVec3("position");
    meshReplace.rotate = eprm->getVec3("rotate");
    meshReplace.scale = eprm->getVec3("scale");

    string replaceWithMesh = eprm->getString("file");

    char uniqueMeshName[256];
    sprintf(uniqueMeshName, "%s_r%d", uniqueID.c_str(), mR);

    int meshIndex = g_D3DApp->addAnimatedMesh(replaceWithMesh.c_str()); //, uniqueMeshName);
    meshReplace.replaceWithMesh = g_D3DApp->getMesh(meshIndex);

    int numAnim = eprm->getN("animate");
    if (numAnim) {
      for (int ia=0; ia<numAnim; ia++) {
        const EffectParam *epa = eprm->get("animate", ia);

        int set = (int)epa->getFloat("set");
        float freq = 1.0f;
        if (epa->getN("freq"))
          freq = epa->getFloat("freq");

        float modTime;
        float animFade;
        int animIsOn;
        float animStartTime;
        float animEndTime;

        epa->GetFadeParams(&animFade, &animIsOn, &modTime, &animStartTime, &animEndTime, freq);

        if (animIsOn) 
          meshReplace.replaceWithMesh->Update(modTime, set);
      }
    }

  //  meshReplace.replaceWithMesh->Update(effectTime);

    if (eprm->getN("replace")) {
      std::list<MeshReplace> childRepList;
      BuildReplaceList(&childRepList, eprm, uniqueMeshName, effectTime);
      meshReplace.replaceList = childRepList;
    }

    replaceList->push_back(meshReplace);
  }
}

void EffectMato::UpdateMato(Mesh *matoMesh) {


  if (!matoMesh->m_pFrameRoot)
    return;

  LPFRAME pFrame = (LPFRAME)matoMesh->m_pFrameRoot;
/*
	if (pParentMatrix) {
		D3DXMatrixMultiply(&pFrame->matCombined, 
			&pFrame->TransformationMatrix, 
			pParentMatrix);
  }	else {
		pFrame->matCombined = pFrame->TransformationMatrix;
  }

	//Do the kid too
	if (pFrame->pFrameSibling) {
		UpdateFrameMatrices((LPFRAME)pFrame->pFrameSibling, pParentMatrix, currentTime, animSetNumber);
	}

	//make sure you get the first kid
	if (pFrame->pFrameFirstChild) {
		UpdateFrameMatrices((LPFRAME)pFrame->pFrameFirstChild, 
				&pFrame->matCombined, currentTime, animSetNumber);
	}
*/

  if (m_lastFollowMat.size() < 1)
    return;


  std::list<D3DXMATRIXA16*>::iterator lastFPiter = m_lastFollowMat.begin();
  D3DXMATRIXA16 *paikkaNyt = (*lastFPiter);
  int paikkaNytI=0;

  std::vector<D3DXMATRIXA16*> boneMatList;

  while (pFrame) {
    if (strstr(pFrame->Name, "Bone")) {
      
      if (paikkaNytI < (int)m_lastFollowMat.size()) {
        paikkaNyt = (*lastFPiter);
        for (int iir=0; iir<1; iir++) {
          if (lastFPiter != m_lastFollowMat.end())
            lastFPiter++;
          paikkaNytI++;
        }
      }

    //  pFrame->TransformationMatrix = *paikkaNyt;
      boneMatList.push_back(paikkaNyt);
   
    }
    pFrame = (LPFRAME)pFrame->pFrameFirstChild;
  }

  pFrame = (LPFRAME)matoMesh->m_pFrameRoot;

  int viiro=0;
  while (pFrame) {
    if (strstr(pFrame->Name, "Bone")) {
      

      pFrame->TransformationMatrix = *boneMatList[boneMatList.size()-1-viiro];
//      pFrame->TransformationMatrix = *boneMatList[viiro];
      viiro++;
      // boneMatList.push_back(paikkaNyt);
   
    }
    pFrame = (LPFRAME)pFrame->pFrameFirstChild;
  }

	LPMESHCONTAINER pMesh = matoMesh->m_pFirstMesh;
	if(pMesh) {
		if(pMesh->pSkinInfo) {
		  UINT Bones = pMesh->pSkinInfo->GetNumBones();
		  for (UINT i = 0; i < Bones; ++i) {	
				pFrame = (LPFRAME)D3DXFrameFind(matoMesh->m_pFrameRoot,
						pMesh->pSkinInfo->GetBoneName(i));

        *pMesh->ppFrameMatrices[i] = pFrame->TransformationMatrix;
      }
    }

    


  }
  


}



// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectMato::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
 // pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);



  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  if (GetClearFlags())
    GetDeferred()->BeginDraw(true);
  else 
    GetDeferred()->BeginDraw(false);



  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;

  D3DXMATRIXA16 tempMatrix;


  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;


  D3DXMatrixPerspectiveFovLH(&matProj, D3DX_PI*0.5f, g_D3DApp->m_aspectRatio, 1.0f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  //draw something


  // draw foreground stuff
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);


  int meshNum = GetPR()->getN("mato");



  GetDeferred()->BeginShader();

  for (int mI=0; mI<meshNum; mI++) {

    const EffectParam *ep;
    ep = GetPR()->get("mato", mI);

    char uniqueMeshName[256];
    sprintf(uniqueMeshName, "e%s_m%d", GetUniqueID().c_str(), mI);

    int meshIndex = g_D3DApp->addAnimatedMesh(ep->getString("file").c_str()); // , uniqueMeshName);
    Mesh *bMesh = g_D3DApp->getMesh(meshIndex);


    static float timpo = 0.0f;
    static float lastFollowTime = 0.0f;

    D3DXVECTOR3 paksuus = ep->getVec3("paksuus");

    int numFollow = ep->getN("follow");
    if (numFollow) {
      const EffectParam *epf;

      while (m_lastFollowMat.size() > 0) {
        delete m_lastFollowMat.front();
        m_lastFollowMat.pop_front();
      }



      for (int fI=0; fI<numFollow; fI++) {
        epf = ep->get("follow", fI);

        std::string followMesh = epf->getString("file");
        std::string followMeshNeedle = epf->getString("needle");
        meshIndex = g_D3DApp->addAnimatedMesh(followMesh.c_str());
        Mesh *fMesh = g_D3DApp->getMesh(meshIndex);

        for (int iti=0; iti<200; iti++) {
          D3DXMATRIXA16 *followMatrix = new D3DXMATRIXA16();
          D3DXMATRIXA16 followMatrixMiddle;
          D3DXMATRIXA16 followMatrixNext;

          D3DXMatrixIdentity(followMatrix);
          D3DXMatrixScaling(followMatrix, 1.0f, 1.0f, 1.0f);

          D3DXMatrixIdentity(&followMatrixMiddle);
          D3DXMatrixScaling(&followMatrixMiddle, 1.0f, 1.0f, 1.0f);

          D3DXMatrixIdentity(&followMatrixNext);
          D3DXMatrixScaling(&followMatrixNext, 1.0f, 1.0f, 1.0f);

          D3DXVECTOR3 sk = epf->getVec3("scale");

          D3DXMATRIXA16 buildMatWorldMy;
          D3DXMATRIXA16 buildMatWorld;

          D3DXMATRIXA16 buildMatWorldMyMiddle;
          D3DXMATRIXA16 buildMatWorldMiddle;

          D3DXMATRIXA16 buildMatWorldMyNext;
          D3DXMATRIXA16 buildMatWorldNext;

          float matoSpeed = ep->getFloat("mato_speed");
          float matoLength = ep->getFloat("mato_length");

          // D3DXMATRIXA16
          float timpo = m_effectTime*matoSpeed+(float)iti*matoLength;

          fMesh->Update(timpo);
          g_D3DApp->getAnimatedMeshMatrix(*fMesh, followMeshNeedle, followMatrix, NULL, &buildMatWorldMy, &buildMatWorld);

          fMesh->Update(timpo+matoLength*0.5f);
          g_D3DApp->getAnimatedMeshMatrix(*fMesh, followMeshNeedle, &followMatrixMiddle, NULL, &buildMatWorldMyMiddle, &buildMatWorldMiddle);

          fMesh->Update(timpo+matoLength);
          g_D3DApp->getAnimatedMeshMatrix(*fMesh, followMeshNeedle, &followMatrixNext, NULL, &buildMatWorldMyNext, &buildMatWorldNext);


          D3DXVECTOR3 posser;
          D3DXVECTOR3 posserMiddle;
          D3DXVECTOR3 posserNext;

          posser.x = followMatrix->_41*sk.x;
          posser.y = followMatrix->_42*sk.y;
          posser.z = followMatrix->_43*sk.z;

          posserMiddle.x = followMatrixMiddle._41*sk.x;
          posserMiddle.y = followMatrixMiddle._42*sk.y;
          posserMiddle.z = followMatrixMiddle._43*sk.z;

          posserNext.x = followMatrixNext._41*sk.x;
          posserNext.y = followMatrixNext._42*sk.y;
          posserNext.z = followMatrixNext._43*sk.z;

          posserNext -= posser;


          float dista = -D3DXVec3Length(&posserNext)*0.125f;

          buildMatWorldMy._11 = buildMatWorldMyMiddle._11;
          buildMatWorldMy._12 = buildMatWorldMyMiddle._12;
          buildMatWorldMy._13 = buildMatWorldMyMiddle._13;

          buildMatWorldMy._21 = buildMatWorldMyMiddle._21;
          buildMatWorldMy._22 = buildMatWorldMyMiddle._22;
          buildMatWorldMy._23 = buildMatWorldMyMiddle._23;

          buildMatWorldMy._31 = buildMatWorldMyMiddle._31;
          buildMatWorldMy._32 = buildMatWorldMyMiddle._32;
          buildMatWorldMy._33 = buildMatWorldMyMiddle._33;


          buildMatWorld._11 = buildMatWorldMiddle._11;
          buildMatWorld._12 = buildMatWorldMiddle._12;
          buildMatWorld._13 = buildMatWorldMiddle._13;

          buildMatWorld._21 = buildMatWorldMiddle._21;
          buildMatWorld._22 = buildMatWorldMiddle._22;
          buildMatWorld._23 = buildMatWorldMiddle._23;

          buildMatWorld._31 = buildMatWorldMiddle._31;
          buildMatWorld._32 = buildMatWorldMiddle._32;
          buildMatWorld._33 = buildMatWorldMiddle._33;



          D3DXMatrixScaling(&tempMatrix, paksuus.x, paksuus.y*dista, paksuus.z);
          buildMatWorldMy = tempMatrix*buildMatWorldMy;

          *followMatrix = buildMatWorldMy*buildMatWorld;

          followMatrix->_41 *= sk.x;
          followMatrix->_42 *= sk.y;
          followMatrix->_43 *= sk.z;

          m_lastFollowMat.push_back(followMatrix);
/*
          D3DXVECTOR3 posser;
          D3DXVECTOR3 posserLast = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
          D3DXVECTOR3 temppu;
          
          posser.x = followMatrix->_41*sk.x;
          posser.y = followMatrix->_42*sk.y;
          posser.z = followMatrix->_43*sk.z;

          if (m_lastFollowMat.size()) {
            D3DXMATRIXA16 lastMat = *m_lastFollowMat.back();
            posserLast.x = lastMat._41;
            posserLast.y = lastMat._42;
            posserLast.z = lastMat._43;
          }

          float dista1 = 1.0f;
          
          temppu = posser-posserLast;

          dista1 = D3DXVec3Length(&temppu)*1.0f;

          float distThr = 0.01f;
          float timeThr = 0.01f;
          float matoSpeed = 0.25f;


          D3DXMatrixScaling(&tempMatrix, paksuus.x, dista1*paksuus.y, paksuus.z);
          buildMatWorldMy = tempMatrix*buildMatWorldMy;

          *followMatrix = buildMatWorldMy*buildMatWorld;

          followMatrix->_41 *= sk.x;
          followMatrix->_42 *= sk.y;
          followMatrix->_43 *= sk.z;

          fMesh->Update(timpo);
          timpo+=m_timeStep*matoSpeed;

          if (((dista1 > distThr) && ((m_effectTime-lastFollowTime)>timeThr))  || m_lastFollowMat.size()==0) {
            lastFollowTime = m_effectTime;
            m_lastFollowMat.push_back(followMatrix);
          }

          */
        }

      }
    }
  //  D3DXVECTOR3 followPosition = ep->getVec3("follow_position");
/*
    while (m_lastFollowMat.size() > 300) {
      delete m_lastFollowMat.front();
      m_lastFollowMat.pop_front();
    }
*/


    std::list<MeshReplace> replaceList;
    replaceList.clear();
//    BuildReplaceList(&replaceList, ep, uniqueMeshName, m_effectTime);


    matView = *GetGlobalCameraView();

    pd3dDevice->SetTransform(D3DTS_VIEW, &matView);

    GetDeferred()->SetView(&matView);

    g_D3DApp->MakeWorldMatrix(&matWorld, 
                              &ep->getVec3("position"), // translate
                              &ep->getVec3("scale"), // scale
                              &ep->getVec3("rotate")); // rotate

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    wvp = matWorld*matView*matProj;
    GetDeferred()->SetWorld(&matWorld);
    GetDeferred()->SetWVP(&wvp);

    int numT = ep->getN("texcoord_scale");
    if (numT)
      GetDeferred()->GetEffect()->SetVector("g_texCoordScale", &ep->getVec4("texcoord_scale"));
    else
      GetDeferred()->GetEffect()->SetVector("g_texCoordScale", &D3DXVECTOR4(1.0f, 1.0f, 0.0f, 0.0f));

    numT = ep->getN("texcoord_ofs");
    if (numT)
      GetDeferred()->GetEffect()->SetVector("g_texCoordScale", &ep->getVec4("texcoord_ofs"));
    else
      GetDeferred()->GetEffect()->SetVector("g_texCoordOfs", &D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f));


    UpdateMato(bMesh);




    int numAnim = ep->getN("animate");
    if (numAnim) {
      for (int ia=0; ia<numAnim; ia++) {
        const EffectParam *epa = ep->get("animate", ia);
        int set = (int)epa->getFloat("set");
        float freq = 1.0f;
        if (epa->getN("freq"))
          freq = epa->getFloat("freq");

        float modTime;
        float animFade;
        int animIsOn;
        float animStartTime;
        float animEndTime;

        epa->GetFadeParams(&animFade, &animIsOn, &modTime, &animStartTime, &animEndTime, freq);

        if (animIsOn) 
          bMesh->UpdateSkin();

      }
    }
    
 //   bMesh->Update(m_effectTime);

    g_D3DApp->drawAnimatedMeshD(*bMesh, &matWorld, &matView, &matProj, &replaceList, false);

  }
  GetDeferred()->EndShader();

  GetDeferred()->EndDraw();


  // End the scene.
  pd3dDevice->EndScene();




  return 1;
}
