
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectLight.h"

#include "EffectOfs.h"

void EffectLight::Init() {
}

void EffectLight::Advance() {
}

/*
bool D3DApp::getFrameH(LPD3DXFRAME frame, std::string frameNameToFind, D3DXMATRIXA16 *matWorld, std::list<MeshReplace> *replaceList) {
  while (frame) {
    LPMESHCONTAINER pM =  (LPMESHCONTAINER)frame->pMeshContainer;

    D3DXMATRIXA16 matWorldMy = frame->TransformationMatrix;

    matWorldMy = matWorldMy*(*matWorld);

    // check that are we in the replace list
    bool replaced = false;
    if (replaceList) {
      D3DXMATRIXA16 inve;
      D3DXMATRIXA16 tempMatrix;
      for (std::list<MeshReplace>::iterator it = replaceList->begin(); it!=replaceList->end(); it++) {
        if (strstr(frame->Name,(*it).needle.c_str())) {

          D3DXMatrixScaling(&inve, (*it).scale.x, (*it).scale.y, -(*it).scale.z);

          D3DXMatrixRotationX(&tempMatrix, (*it).rotate.x);
          D3DXMatrixMultiply(&inve, &inve, &tempMatrix);
          D3DXMatrixRotationY(&tempMatrix, (*it).rotate.y);
          D3DXMatrixMultiply(&inve, &inve, &tempMatrix);
          D3DXMatrixRotationZ(&tempMatrix, (*it).rotate.z);
          D3DXMatrixMultiply(&inve, &inve, &tempMatrix);

          D3DXMatrixTranslation(&tempMatrix, (*it).position.x, (*it).position.y, (*it).position.z);
          D3DXMatrixMultiply(&inve, &inve, &tempMatrix);

          D3DXMATRIXA16 matWorldMyInv = inve*matWorldMy;

          bool found = getAnimatedMeshMatrix(*(*it).replaceWithMesh, frameNameToFind, &matWorldMyInv, &(*it).replaceList);
          if (found) {
            *matWorld = matWorldMyInv;
            return true;
          }
          replaced = true;
        }
      }
    }

    if (_stricmp(frame->Name, frameNameToFind.c_str())==0) {
      *matWorld = matWorldMy;
      return true;
    }

    if (frame->pFrameFirstChild) {
      if (getFrameH(frame->pFrameFirstChild, frameNameToFind, &matWorldMy, replaceList)) {
        *matWorld = matWorldMy;
        return true;
      }
    }

    frame = frame->pFrameSibling;
  }

  return false;
}


bool D3DApp::getAnimatedMeshMatrix(Mesh &mesh, std::string frameNameToFind, D3DXMATRIXA16 *matWorld, std::list<MeshReplace> *replaceList) {

  LPMESHCONTAINER pMesh = (LPMESHCONTAINER)mesh.m_pFirstMesh;

// NON BONED BUT KEYFRAMED ANIMATIONS
  LPD3DXFRAME frame = mesh.m_pFrameRoot;

//  drawFrameH(frame, matWorld, matView, matProj, replaceList);
  getFrameH(frame, frameNameToFind, matWorld, replaceList);

  return D3D_OK;

}

*/
void addFrameLights(const EffectParam *p, LPD3DXFRAME frame, std::string frameNameToFind, D3DXMATRIXA16 *matWorld, Light *baseLight) {

  while (frame) {
    LPMESHCONTAINER pM =  (LPMESHCONTAINER)frame->pMeshContainer;

    D3DXMATRIXA16 matWorldMy = frame->TransformationMatrix;

    matWorldMy = matWorldMy*(*matWorld);

    if (strstr(frame->Name, frameNameToFind.c_str())) {
      Light light;
      light = *baseLight;

      D3DXVECTOR3 oScale;
      D3DXQUATERNION oRot;
      D3DXVECTOR3 oTrans;

      D3DXMatrixDecompose(&oScale, &oRot, &oTrans, &matWorldMy);

      if (p->getN("color") == 0) {
        if (pM->NumMaterials) {
          light.m_color.x = pM->pMaterials9[0].Diffuse.r;
          light.m_color.y = pM->pMaterials9[0].Diffuse.g;
          light.m_color.z = pM->pMaterials9[0].Diffuse.b;
          light.m_color.w = 1.0f;
        }
      }
      

      light.m_position = D3DXVECTOR4(oTrans.x, oTrans.y, oTrans.z, 1.0f);
            
      AddToGlobalLights(&light);
    }

    if (frame->pFrameFirstChild) {
      addFrameLights(p, frame->pFrameFirstChild, frameNameToFind, &matWorldMy, baseLight);
    }

    frame = frame->pFrameSibling;
  }

}

void recursiveGlobalLightAdd(const EffectParam *p, float absTime, std::string fileName, std::string lightMeshName, Light *baseLight) {
  Mesh *mesh; 

  int meshI = g_D3DApp->addAnimatedMesh(fileName.c_str(), NULL, NULL);
  mesh = g_D3DApp->getMesh(meshI);

  mesh->Update(absTime);

  LPMESHCONTAINER pMesh = (LPMESHCONTAINER)mesh->m_pFirstMesh;

  LPD3DXFRAME frame = mesh->m_pFrameRoot;

  D3DXMATRIXA16 matWorld;

  g_D3DApp->MakeWorldMatrix(&matWorld, 
    &p->getVec3("position"),
    &p->getVec3("scale"),
    &p->getVec3("rotate"));

  addFrameLights(p, frame, lightMeshName, &matWorld, baseLight);

}


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectLight::Render() {

//  m_layout->getElement("settings")->;

/*
    <intensity>1.0</intensity>
    <distance>1.0</distance>
    <ss_size>100.0</ss_size>
    <lightball>
      <size>8.0</size>
      <sharpness>0.750</sharpness>
    </lightball>
*/

  int numLights = GetPR()->getN("light");
  for (int i=0; i<numLights; i++) {
    const EffectParam *p;
    p = GetPR()->get("light", i);
    if (p->hide == 1)
      continue;

    Light light;

    light.m_position = p->getVec4("position")+*GetGlobalOffset();
    light.m_position.w = 1.0f;
    light.m_color = p->getVec4("color");
    light.m_intensity = p->getFloat("intensity");
    light.m_distance = p->getFloat("distance");
    light.m_ss_size = p->getFloat("ss_size");
    light.m_lightball_size = p->getFloat("lightball_size");
    light.m_lightball_sharpness = p->getFloat("lightball_sharpness");

    light.m_bCastShadows = false;
    
    if (p->get("shadows")) {
      light.m_bCastShadows = p->getInt("shadows");
    }
    

    if (p->getN("file")) {
      std::string fileName = p->getString("file");
      // recursively add lights from the file
      std::string lightMeshName = p->getString("lights");
      recursiveGlobalLightAdd(p, m_effectTime, fileName, lightMeshName, &light);
    } else {
      AddToGlobalLights(&light);
    }
  }

  return true;
}


