
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"
#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectGameProto.h"

#include "ContextData.h"
#include "DemoContextData.h"

#include "EffectCamera.h"
#include "camera.h"

void EffectGameProto::Init() {
  for (std::vector<Ship*>::iterator it=m_playerShips.begin(); it!=m_playerShips.end(); it++) {
    if (*it) {
      delete (*it);
    }
  }
  m_playerShips.clear();

  g_D3DApp->CreateD3DXTextMesh(&m_meshPlayerName, "Player 1", 64);


  Ship *playerShip;

  const EffectParam *epGame = GetPR()->get("game_proto");

  m_currentCamMultiplier = 1.0f;
  m_avp = D3DXVECTOR3(0.0f, 0.0f, 0.0f);


  int players = epGame->getFloat("players");

  if (players > 0) {
    playerShip = new Ship(D3DXVECTOR4(-100.0f, 0.0f, 0.0f, 1.0f), false, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 1500.0f, D3DXVECTOR4(1.0f, 1.0f, 1.4f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
  if (players > 1) {
    playerShip = new Ship(D3DXVECTOR4(100.0f, 0.0f, 0.0f, 1.0f), true, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 1500.0f, D3DXVECTOR4(1.30f, 0.30f, 0.40f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
  if (players > 2) {
    playerShip = new Ship(D3DXVECTOR4(0.0f, 100.0f, 0.0f, 1.0f), true, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 1500.0f, D3DXVECTOR4(0.30f, 1.30f, 0.40f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
  
  if (players > 3) {
    playerShip = new Ship(D3DXVECTOR4(0.0f, -100.0f, 0.0f, 1.0f), true, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 500.0f, D3DXVECTOR4(1.30f, 1.30f, 0.40f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
/**/
}


//  int m_keys[256];
//  int m_keysDown[256];
//  float m_keyDownTime[256];
bool EffectGameProto::HandleInput() {
  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();


  return true;
}


void EffectGameProto::Advance() {
  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();

  const EffectParam *epGame = GetPR()->get("game_proto");
  const EffectParam *epShip = GetPR()->get("ship");

  float timeStep = cd->m_timeStep;
  if (timeStep > 0.1f) {
    timeStep = 0.1f;
  }


  float totalCamMultiplier = 0.0f;
  float maxDistance = 0.0f;
  int numShips=0;
  D3DXVECTOR4 averagePos = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);
  for (std::vector<Ship*>::iterator it=m_playerShips.begin(); it!=m_playerShips.end(); it++) {
    std::vector<Ship*> otherShips;
    for (std::vector<Ship*>::iterator itOthers=m_playerShips.begin(); itOthers!=m_playerShips.end(); itOthers++) {
      if ((*it)!=(*itOthers)) {
        otherShips.push_back(*itOthers);
        D3DXVECTOR4 distVec = (*it)->GetPosition()-(*itOthers)->GetPosition();
        float dist = D3DXVec4Length(&distVec);
        maxDistance = max(dist, maxDistance);
      }
    }
    (*it)->Advance(cd->m_timeFloat, timeStep, otherShips, epGame, epShip);
    float distanceToCenter = D3DXVec4Length(&(*it)->GetPosition());
    totalCamMultiplier = max(totalCamMultiplier, distanceToCenter);

    averagePos += (*it)->GetPosition();
    numShips++;
  }
  averagePos /= (float)numShips;

  totalCamMultiplier = maxDistance;
  totalCamMultiplier *= 0.01f;
  totalCamMultiplier-=0.50f;
  if (totalCamMultiplier < 0.750f) {
    totalCamMultiplier = 0.750f;
  }
  if (totalCamMultiplier > 2.0f) {
    totalCamMultiplier = 2.0f;
  }
  m_currentCamMultiplier += (totalCamMultiplier-m_currentCamMultiplier)*timeStep*epGame->getFloat("cam_multiplier_follow_speed");
  MultiplyGlobalCameraPos(m_currentCamMultiplier);


  m_avp.x += (averagePos.x-m_avp.x)*timeStep*epGame->getFloat("cam_pos_follow_speed");
  m_avp.y += (averagePos.y-m_avp.y)*timeStep*epGame->getFloat("cam_pos_follow_speed");
  m_avp.z =+ (averagePos.z-m_avp.z)*timeStep*epGame->getFloat("cam_pos_follow_speed");
  AddToGlobalCameraPos(&m_avp, &m_avp);

}


void Ship::AddForce(D3DXVECTOR4 force) {
  m_force += force;
}

void Ship::MoveRight() {
  AddForce(D3DXVECTOR4(m_moveForce, 0.0f, 0.0f, 0.0f));
}
void Ship::MoveLeft() {
  AddForce(D3DXVECTOR4(-m_moveForce, 0.0f, 0.0f, 0.0f));
}
void Ship::MoveUp() {
  AddForce(D3DXVECTOR4(0.0f, -m_moveForce, 0.0f, 0.0f));
}
void Ship::MoveDown() {
  AddForce(D3DXVECTOR4(0.0f, m_moveForce, 0.0f, 0.0f));
}

// Shoot out energy ammo of the given percentage of own energy
// shot is made into the direction of the current movement
// if not moving above the threshold speed, shot not possible
// shootSpeedFactor is the multiplier to multiply ships speed given as initial speed of the ammo
bool Ship::Shoot() {

  // if enough velocity, generate new ammo
 float velocity = D3DXVec4Length(&m_speed);
 if ((velocity > m_weaponThresholdVelocity) && m_ammos.size()<2) {
   float energyForAmmo = m_energy*m_weaponEnergyPercent;
   m_energy -= energyForAmmo;
   D3DXVECTOR4 ammoSpeed = m_weaponShootSpeedFactor*m_speed;
   m_speed -= ammoSpeed*energyForAmmo;
   Ammo ammo(m_position, ammoSpeed, energyForAmmo, m_color);
   m_ammos.push_back(ammo);
   return true;
 }
 return false;
}

void Ship::Flee(D3DXVECTOR4 *v) {
  if (fabs(v->x)>fabs(v->y)*0.5f) {
    if (v->x > 0.0f) {
      m_bComputerMoveRight = true;
    } else {
      m_bComputerMoveLeft = true;
    }
  }
  if (fabs(v->y)>fabs(v->x)*0.5f) {
    if (v->y > 0.0f) {
      m_bComputerMoveDown = true;
    } else {
      m_bComputerMoveUp = true;
    }
  }
}


void Ship::Approach(D3DXVECTOR4 *v) {
  if (fabs(v->x)>fabs(v->y)*0.5f) {
    if (v->x > 0.0f) {
      m_bComputerMoveLeft = true;
    } else {
      m_bComputerMoveRight = true;
    }
  }
  if (fabs(v->y)>fabs(v->x)*0.5f) {
    if (v->y > 0.0f) {
      m_bComputerMoveUp = true;
    } else {
      m_bComputerMoveDown = true;
    }
  }
}

// advance calculates the force based on the main movement and sets the force as zero in the end
void Ship::Advance(float timeAbs, float timeStep, std::vector<Ship*> otherShips, const EffectParam *epGame, const EffectParam *epShip) {

  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();


  if (!m_bIsDead) {
    if (m_bIsComputer) {
      // apply some very simple AI here ...


      // update braveness, braveness basically determines how near the ship comes to other ships
      if (timeAbs > m_computerBravenessUpdateTime) {
        m_computerBravenessUpdateTime = timeAbs+0.30f+2.0f*(float)rand()/RAND_MAX;
        m_computerBraveness = (float)rand()/RAND_MAX;
      }

      m_bComputerMoveLeft = false;
      m_bComputerMoveRight = false;
      m_bComputerMoveUp = false;
      m_bComputerMoveDown = false;

      for (std::vector<Ship*>::iterator it=otherShips.begin(); it!=otherShips.end(); it++) {
        D3DXVECTOR4 posDelta = m_position-(*it)->GetPosition();
        float distance = D3DXVec4Length(&posDelta);

        // go away from other ships too near
        if (distance < (200.0f-180.0f*m_computerBraveness)) {
          Flee(&posDelta);
        }

        // approach ships that are far enough
        if (distance > (600.0f-550.0f*m_computerBraveness)) {
          Approach(&posDelta);
        }
        

        // shoot ships at appropriate distance
        if (distance < 400.0f) {
          float velocity = D3DXVec4Length(&m_speed);
          float dot = (D3DXVec4Dot(&posDelta, &m_speed)/(velocity*distance+0.001f));
          if (dot<-0.8f && timeAbs>m_computerNextShootTime) {
            m_computerNextShootTime = timeAbs+0.2f+0.80f*(float)rand()/RAND_MAX;
            Shoot();
          }
        }

        // go away from ammos
        for (std::vector<Ammo>::const_iterator itAmmo=(*it)->GetAmmos()->begin(); itAmmo!=(*it)->GetAmmos()->end(); itAmmo++) {
          D3DXVECTOR4 posDelta = m_position-(*itAmmo).GetPosition();
          float distance = D3DXVec4Length(&posDelta);
          if (distance < 100.0f) {
            if ((rand()&1)==0) {
              Flee(&posDelta);
            }
          }
        }
        

      }

    //  if (!(m_bComputerMoveRight || m_bComputerMoveLeft || m_bComputerMoveUp || m_bComputerMoveDown) && m_ammos.size()<2) {
      if (m_ammos.size()<2) {

        if (timeAbs > m_computerUpdateDirTime) {
          m_computerMoveLeftRight = rand()%3;
          m_computerMoveUpDown = rand()%3;
          m_computerUpdateDirTime = timeAbs+0.1f+0.750f*(float)rand()/RAND_MAX;
        }

        if (m_computerMoveLeftRight==0) {
          m_bComputerMoveLeft = true;
        }
        if (m_computerMoveLeftRight==2) {
          m_bComputerMoveRight = true;
        }
        if (m_computerMoveUpDown==0) {
          m_bComputerMoveUp = true;
        }
        if (m_computerMoveUpDown==2) {
          m_bComputerMoveDown = true;
        }
      }


      if (m_bComputerMoveRight) {
        MoveRight();
      }
      if (m_bComputerMoveLeft) {
        MoveLeft();
      }
      if (m_bComputerMoveUp) {
        MoveUp();
      }
      if (m_bComputerMoveDown) {
        MoveDown();
      }

    } else {
      if (cd->m_keysDown[65]) { // A
        MoveLeft();
      }
      if (cd->m_keysDown[68]) { // D
        MoveRight();
      }
      if (cd->m_keysDown[87]) { // W
        MoveUp();
      }
      if (cd->m_keysDown[83]) { // S
        MoveDown();
      }

      if (cd->m_keysDown[49]==1) { // 1
        // shoot some energy
        Shoot();
      }
    }
  }

  if (m_bIsDead) {
    if (m_energy > 0.25f) {
      m_bIsDead = false;
    }
  }


  // advance the ammos
  for (std::vector<Ammo>::iterator it=m_ammos.begin(); it!=m_ammos.end();) {

    for (std::vector<Ship*>::iterator itOtherShips=otherShips.begin(); itOtherShips!=otherShips.end(); itOtherShips++) {
      if (it->IsHittingShip((*itOtherShips)->GetPosition(), (*itOtherShips)->GetEnergy()) && !it->CarryingEnergy()) {
        it->AddEnergy((*itOtherShips)->RemoveEnergy(it->GetEnergy()));
        it->SetCarryingEnergy();
      }
    }

    if (it->IsBackToShip(m_position, m_energy)) {
      m_energy += it->GetEnergy();
      it = m_ammos.erase(it);
    } else {
      if (it->GetLifeTime() > m_weaponBackToMamaTime) {
        D3DXVECTOR4 backToShipForce = (m_position - it->GetPosition());
        float bsLen = D3DXVec4Length(&backToShipForce);
        float ammoVelocity = D3DXVec4Length(&it->GetSpeed());
        float forceSpeedDot = D3DXVec4Dot(&backToShipForce, &it->GetSpeed())/(ammoVelocity*bsLen+0.001f)+1.0f; // about 0 - 2.0
        forceSpeedDot = (2.0f-forceSpeedDot)*0.5f;
        backToShipForce -= forceSpeedDot*it->GetSpeed();
        backToShipForce *= m_weaponBackToShipForce*it->GetLifeTime();
        it->AddForce(backToShipForce);
      }

      it->Advance(timeAbs, timeStep);
      it++;
    }
  }

  // all ships share a force which keeps them at the play-area

  float distanceFromOrigo = D3DXVec4Length(&m_position);
  if (distanceFromOrigo > epGame->getFloat("play_area_range")) {
    D3DXVECTOR4 backToOrigoForce = -m_position*epGame->getFloat("play_area_force_mul");
    backToOrigoForce.w = 0.0f;
    m_force+=backToOrigoForce;
  }


  // apply force to speed
  m_speed += m_force*m_energy*timeStep;
  m_position += m_speed*timeStep;
  m_force = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);

  // advance speed
  // some "air" friction
  float velocity = D3DXVec4Length(&m_speed);
  float frict = velocity*0.01f*timeStep;
  frict = 1.0f-frict;
  if (frict < 0.0f) {
    frict = 0.0f;
  }
  m_speed *= frict;

}

void Ship::Render() {

  Light light;

  light.m_position = m_position;
  light.m_color = m_color;
  light.m_intensity = 15.0f*m_energy;
  light.m_distance = 30.0f;
  light.m_ss_size = 16.0f;
  light.m_lightball_size = 10.0f*m_energy;
  light.m_lightball_sharpness = 0.5f;

  AddToGlobalLights(&light);


  // render the ammos
  for (std::vector<Ammo>::iterator it=m_ammos.begin(); it!=m_ammos.end(); it++) {
    (*it).Render();
  }


}

void Ammo::AddForce(D3DXVECTOR4 force) {
  m_force += force;
}

void Ammo::Advance(float timeAbs, float timeStep) {

  // apply force to speed
  m_speed += m_force*m_energy*timeStep;
  m_position += m_speed*timeStep;
  m_force = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);

  // advance speed
  // some "air" friction
  float velocity = D3DXVec4Length(&m_speed);
  float frict = velocity*0.005f*timeStep;
  frict = 1.0f-frict;
  if (frict < 0.0f) {
    frict = 0.0f;
  }
  m_speed *= frict;

  m_lifeTime += timeStep;

}

bool Ammo::IsBackToShip(D3DXVECTOR4 shipPosition, float shipEnergy) {
  D3DXVECTOR4 vecToShip = shipPosition-m_position;
  float distToShip = D3DXVec4Length(&vecToShip);
  if (distToShip < 12.0f) {
    float velocity = D3DXVec4Length(&m_speed);
    float dotToShip = D3DXVec4Dot(&vecToShip, &m_speed)/(velocity*distToShip+0.001);
    if (dotToShip > 0.7) {
      return true;
    }
  }
  return false;
}

bool Ammo::IsHittingShip(D3DXVECTOR4 shipPosition, float shipEnergy) {
  D3DXVECTOR4 vecToShip = shipPosition-m_position;
  float distToShip = D3DXVec4Length(&vecToShip);
  if (distToShip < 40.0f*shipEnergy) {
    float velocity = D3DXVec4Length(&m_speed);
    float dotToShip = D3DXVec4Dot(&vecToShip, &m_speed)/(velocity*distToShip+0.001);
    if (dotToShip > 0.5) {
      return true;
    }
  }
  return false;
}


void Ammo::Render() {

  Light light;

  light.m_position = m_position;
  light.m_color = m_color;
  light.m_intensity = 64.0f*m_energy;
  light.m_distance = 6.0f;
  light.m_ss_size = 10.0f;
  light.m_lightball_size = 200.0f*m_energy;
  light.m_lightball_sharpness = 0.90f;

  AddToGlobalLights(&light);

}


float AtanSafe(float y, float x) {
 float ret;
	if (x!=0.0f) {
		if (x>0.0f) {
			ret=atanf(y/x);
		} else	{
			ret=atanf(y/x)+3.141592f;
		}
	} else	{
		if (y>=0.0f) {
			ret=0.5f*3.141592f;
		} else {
			ret=-0.5f*3.141592f;
		}
	}
 return ret;
}


// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectGameProto::Render() {

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  const EffectParam *ep;
  ep = GetPR()->get("game_proto");


  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();


  ep = GetPR()->get("ship", 0);


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);
 // pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_DIFFUSE);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);


  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);


  // first set camera according to the current camera
  // (discard global camera)
  // ...
  // ..
  // .
  // TBD: now use the global camera :)
  // 

  // then set lights according to the current state

  for (std::vector<Ship*>::iterator it=m_playerShips.begin(); it!=m_playerShips.end(); it++) {
    (*it)->Render();
  }

  // then draw meshes according to the current state




  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  if (GetClearFlags()) {
    GetDeferred()->BeginDraw(true);
  } else {
    GetDeferred()->BeginDraw(false);
  }
  GetDeferred()->BeginShader();

  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;

  D3DXMatrixPerspectiveFovLH(&matProj, D3DX_PI*0.5f, g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  matView = *GetGlobalCameraView();
  pd3dDevice->SetTransform(D3DTS_VIEW, &matView);
  GetDeferred()->SetView(&matView);

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);

  int meshIndex = g_D3DApp->addAnimatedMesh(ep->getString("file").c_str(), NULL, NULL); // , uniqueMeshName);
  Mesh *mesh = g_D3DApp->getMesh(meshIndex);

  meshIndex = g_D3DApp->addAnimatedMesh(ep->getString("file_ammo").c_str(), NULL, NULL); // , uniqueMeshName);
  Mesh *meshAmmoLine = g_D3DApp->getMesh(meshIndex);

  for (std::vector<Ship*>::iterator it=m_playerShips.begin(); it!=m_playerShips.end(); it++) {

    D3DXVECTOR3 position((*it)->GetPosition().x, (*it)->GetPosition().y, (*it)->GetPosition().z);
    float angleOfShip = AtanSafe((*it)->GetSpeed().y, (*it)->GetSpeed().x)/(2.0f*3.141592f)*360.0f;
    D3DXVECTOR3 rotate(0.0f, 0.0f, angleOfShip);

    g_D3DApp->MakeWorldMatrix(&matWorld,
                              &(position+ep->getVec3("position")), // translate
                              &ep->getVec3("scale"), // scale
                              &(rotate+ep->getVec3("rotate"))); // rotate

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
    GetDeferred()->SetWorld(&matWorld);

    wvp = matWorld*matView*matProj;
    GetDeferred()->SetWVP(&wvp);

    g_D3DApp->drawAnimatedMeshD(*mesh, &matWorld, &matView, &matProj, NULL);


/*
	<player_name_position>0.0, 0.0, 80.0</player_name_position>
	<player_name_scale>10.0, 10.0, 10.0</player_name_scale>
	<player_name_rotate>0.0, 0.0, 0.0</player_name_rotate>
*/

    g_D3DApp->MakeWorldMatrix(&matWorld,
                              &(position+ep->getVec3("player_name_position")), // translate
                              &ep->getVec3("player_name_scale"), // scale
                              &ep->getVec3("player_name_rotate")); // rotate

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
    GetDeferred()->SetWorld(&matWorld);

    wvp = matWorld*matView*matProj;
    GetDeferred()->SetWVP(&wvp);

    m_meshPlayerName->DrawSubset(0);

  //  g_D3DApp->drawMeshD


    for (std::vector<Ammo>::const_iterator itAmmo=(*it)->GetAmmos()->begin(); itAmmo!=(*it)->GetAmmos()->end(); itAmmo++) {
      g_D3DApp->CalculateLineTransform(&matWorld, &ep->getVec4("scale_ammo"),
                                       (*it)->GetPosition().x, (*it)->GetPosition().y, (*it)->GetPosition().z,
                                       (*itAmmo).GetPosition().x, (*itAmmo).GetPosition().y, (*itAmmo).GetPosition().z);
      pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
      GetDeferred()->SetWorld(&matWorld);

      wvp = matWorld*matView*matProj;
      GetDeferred()->SetWVP(&wvp);

      g_D3DApp->drawAnimatedMeshD(*mesh, &matWorld, &matView, &matProj, NULL);

    }

  }

  GetDeferred()->EndShader();

  GetDeferred()->EndDraw();


  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
