
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

#include "process.h"

using std::list;
using std::vector;
using std::string;


#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectGameCubicle.h"

#include "ContextData.h"
#include "DemoContextData.h"

#include "EffectCamera.h"
#include "camera.h"

#include "deferred.h"

#include "mesh.h"

#include "Physics.h"



EffectGameCubicle::EffectGameCubicle() {
  m_currentLevelIndex = 0;
  m_timelineType = render;
}

EffectGameCubicle::~EffectGameCubicle() {
  for (std::vector<GameCubicleLevel *>::iterator itLevel=m_levels.begin(); itLevel!=m_levels.end(); itLevel++) {
    delete (*itLevel);
  }
}

bool EffectGameCubicle::ReloadEffect() {
  const EffectParam *epGame = GetPR()->get("game_cubicle");
  int levelIndex = 0;
  for (std::vector<GameCubicleLevel *>::iterator itLevel=m_levels.begin(); itLevel!=m_levels.end(); itLevel++) {
    const EffectParam *epLevel = epGame->get("level", levelIndex);
    (*itLevel)->FreeAll();
    (*itLevel)->Reload(epLevel, epGame);
    levelIndex++;
  }
  return true;
}

bool GameCubicleLevel::Reload(const EffectParam *epLevel, const EffectParam *epGame) {

  m_epGame = epGame;
  m_epLevel = epLevel;

  m_pNextBlock = NULL;
  
  D3DXVECTOR3 gridRes = D3DXVECTOR3(128.0f, 128.0f, 0.0f);
  D3DXVECTOR3 gridCellSize = D3DXVECTOR3(0.12f, 0.12f, 0.0f);
  float gridTimeStep = 0.001f;
  const EffectParam *epSimGrid = m_epLevel->get("simulation_grid", 0);
  if (epSimGrid) {
    gridRes = epSimGrid->getVec3("resolution");
    gridCellSize = epSimGrid->getVec3("cell_size");
    gridTimeStep = epSimGrid->getFloat("time_step");
  }

  // TBD: these settings should also be configurable per level
  m_physicsGrid.InitGrid(gridRes.x, gridRes.y, gridCellSize.x, gridCellSize.y, gridTimeStep);

  m_physicsGrid.ClearForces();
  int numForces = m_epLevel->getN("force");
  for (int forceI=0; forceI<numForces; forceI++) {
    const EffectParam *epForce = m_epLevel->get("force", forceI);
    D3DXVECTOR3 force = epForce->getVec3("value");
    m_physicsGrid.AddStaticDirectionalForce(force);
  }

  // initialize tykki
  const EffectParam *epTykki = m_epLevel->get("tykki");
  if (epTykki) {
    const EffectParam *epMoveArea = epTykki->get("move_area");
    if (epMoveArea) {
      m_tykkiArea.m_posTopLeft = epMoveArea->getVec3("top_left");
      m_tykkiArea.m_posBottomRight = epMoveArea->getVec3("bottom_right");
    }
    m_tykkiPos = (m_tykkiArea.m_posTopLeft+m_tykkiArea.m_posBottomRight)*0.5f;
    m_tykkiPos.x = 6.0f;
    m_tykkiAngle = 0.0f;
    m_tykkiPower = 0.50f;
    m_tykkiPowerMax = epTykki->getFloat("max_power");
    m_epTykkiMesh = epTykki->get("mesh");
    m_pTykkiMesh = g_D3DApp->getMesh(g_D3DApp->addAnimatedMesh(m_epTykkiMesh->getString("model").c_str(), NULL, NULL));
  }


  PhysicsParticleCollection *ppc;

  srand(2012);

  const EffectParam *pPhGroup = m_epLevel->get("ph_group", 0); // "ph_box1"

  if (pPhGroup) {
    std::string groupPositionType = pPhGroup->getString("position_type");
    enum GroupPositionType {
      RANDOM,
      GRID,
      LINE,
    };
    GroupPositionType gpt = RANDOM;
    if (strcmp(groupPositionType.c_str(), "RANDOM")==0) {
      gpt = RANDOM;
    } else if (strcmp(groupPositionType.c_str(), "GRID")==0) {
      gpt = GRID;
    } else if (strcmp(groupPositionType.c_str(), "LINE")==0) {
      gpt = LINE;
    }

    std::string phToUseId = pPhGroup->getString("ph_to_use");
    const EffectParam *pPhBox = m_epGame->getByNameAndId("ph", phToUseId);
    if (pPhBox) {
      float diamX = pPhBox->getVec3("scale").x;
      float diamY = pPhBox->getVec3("scale").y;
      float diamZ = pPhBox->getVec3("scale").z;
      int wx = pPhBox->getVec3("particles").x;
      int wy = pPhBox->getVec3("particles").y;
      int numBoxes = pPhGroup->getInt("amount");
      float boxMass = pPhBox->getFloat("total_mass");
      int span = pPhGroup->getInt("span");
      D3DXVECTOR3 groupOffset = pPhGroup->getVec3("position");
      D3DXVECTOR3 groupScale = pPhGroup->getVec3("scale");

      std::vector<D3DXVECTOR3> previousPositions;
      for (int i=0; i < numBoxes; i++) {
        ppc = new PhysicsParticleCollection();
        float diamSq = diamX*diamX*1.5f;
        D3DXVECTOR3 particlePos;
        bool bColliding = true;
        int iterations = 0;
        float boxAngle = 0.0f;
        while (bColliding && iterations < 4000) {
          if (gpt == RANDOM) {
            particlePos = D3DXVECTOR3(2.0f*(float)rand()/RAND_MAX-1.0f, 2.0f*(float)rand()/RAND_MAX-1.0f, 0.0f);
            boxAngle = (float)rand()/RAND_MAX*360.0f;
          } else if (gpt == GRID) {
            int k = span;
            int iy = i/k;
            int my = numBoxes/k;
            int ix = i-iy*k;
            particlePos = D3DXVECTOR3((-1.0f+(float)ix/(float)k*2.0f)*(float)k*0.55f*diamX, -diamY*1.1f*((float)iy), 0.0f);
          }
          particlePos.x *= groupScale.x;
          particlePos.y *= groupScale.y;
          particlePos += groupOffset;
          bColliding = false;
          if (gpt == RANDOM) {
            for (std::vector<D3DXVECTOR3>::iterator itPrev=previousPositions.begin(); itPrev!=previousPositions.end(); itPrev++) {
              float distSq = D3DXVec3LengthSq(&((*itPrev)-particlePos));
              if (distSq < diamSq) {
                bColliding = true;
              }
            }
          }
          iterations++;
          if (iterations >= 4000) {
       //     _asm int 3;
          }
        }
        if (iterations >= 4000) {
          break; // do not continue when collided
        }
        previousPositions.push_back(particlePos);
        ppc->InitFromTexture(NULL, &particlePos, diamX, diamY, diamZ, wx, wy, true, boxMass, boxAngle);
        m_physicsParticleCollections.push_back(ppc);
      }
    }
  }

 // for (int i=0; i<30; i++) {
  {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(4.650f, -0.5f-2.0f, 0.0f), 0.10f, 4.0f, 0.125f, 4, 80, false, 4.0f, 0.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
 // for (int i=-30; i<30; i++) {
  {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(0.0f, -0.50f, 0.0f), 9.0f, 0.10f, 0.125f, 180, 4, false, 4.0f, 0.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
 // for (int i=0; i<30; i++) {
  {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(-4.650f, -0.5f-2.0f, 0.0f), 0.1f, 4.0f, 0.125f, 4, 80, false, 4.0f, 0.0f);
    m_physicsParticleCollections.push_back(ppc);
  }


  // for (int i=-12; i<10; i++) {
  {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(0.0f, -2.0f, 0.0f), 2.0f, 0.10f, 0.125f, 40, 4, false, 4.0f, 0.0f);
    m_physicsParticleCollections.push_back(ppc);
  }

 // for (int i=-10; i<10; i++) {
  {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(2.0f, -4.0f, 0.0f), 2.0f, 0.10f, 0.125f, 40, 4, false, 4.0f, -10.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
  
  
/*
  ppc = new PhysicsParticleCollection();
  ppc->InitFromTexture(NULL, &D3DXVECTOR3(0.750f, -1.50f, 0.0f), 0.40f, 0.40f, true, 4.0f);
  m_physicsParticleCollections.push_back(ppc);

  ppc = new PhysicsParticleCollection();
  ppc->InitFromTexture(NULL, &D3DXVECTOR3(-0.50f, -1.50f, 0.0f), 0.40f, 0.40f, true, 4.0f);
  m_physicsParticleCollections.push_back(ppc);
*/

/*
  
  for (int i=0; i<30; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(4.50f, -i*0.2f-0.5f, 0.0f), 0.10f, 0.10f, 4, 4, true, 4.0f, 0.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
  for (int i=0; i<30; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(-4.50f, -i*0.2f-0.5f, 0.0f), 0.1f, 0.10f, 4, 4, true, 4.0f, 0.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
  */

  return true;

}

void GameCubicleLevel::FreeAll() {
  for (std::vector<PhysicsParticleCollection*>::iterator it=m_physicsParticleCollections.begin(); it!=m_physicsParticleCollections.end(); it++) {
    delete (*it);
  }
  m_physicsParticleCollections.clear();
}

bool GameCubicleLevel::Init(const EffectParam *epLevel, const EffectParam *epGame) {
  return Reload(epLevel, epGame);
}

void EffectGameCubicle::Init() {

 // g_D3DApp->CreateD3DXTextMesh(&m_meshPlayerName, "Player 1", 64);

  const EffectParam *epGame = GetPR()->get("game_cubicle");

  /*
  m_currentCamMultiplier = 1.0f;
  m_avp = D3DXVECTOR3(0.0f, 0.0f, 0.0f);

  int players = epGame->getFloat("players");

  if (players > 0) {
    playerShip = new Ship(D3DXVECTOR4(-100.0f, 0.0f, 0.0f, 1.0f), false, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 1500.0f, D3DXVECTOR4(1.0f, 1.0f, 1.4f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
  if (players > 1) {
    playerShip = new Ship(D3DXVECTOR4(100.0f, 0.0f, 0.0f, 1.0f), true, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 1500.0f, D3DXVECTOR4(1.30f, 0.30f, 0.40f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
  if (players > 2) {
    playerShip = new Ship(D3DXVECTOR4(0.0f, 100.0f, 0.0f, 1.0f), true, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 1500.0f, D3DXVECTOR4(0.30f, 1.30f, 0.40f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
  
  if (players > 3) {
    playerShip = new Ship(D3DXVECTOR4(0.0f, -100.0f, 0.0f, 1.0f), true, D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f), 1.0f, 500.0f, D3DXVECTOR4(1.30f, 1.30f, 0.40f, 1.0f));
    m_playerShips.push_back(playerShip);
  }
/**/

  // Initialize the levels

/*
  m_physicsGrid.InitGrid(128, 128, 0.50f, 0.50f);

  // add some gravity
  m_physicsGrid.AddStaticDirectionalForce(D3DXVECTOR3(0.0f, 8.0f, 0.0f));
*/

  // TBD: physicsgrid & force fields are properties of the levels 

  int numLevels = epGame->getN("level");
  for (int levelNumber=0; levelNumber<numLevels; levelNumber++) {
    const EffectParam *epLevel = epGame->get("level", levelNumber);

    GameCubicleLevel *pLevel = new GameCubicleLevel();
    pLevel->Init(epLevel, epGame);

    m_levels.push_back(pLevel);

  }

  /*
  PhysicsParticleCollection *ppc;

  srand(1981);

  std::vector<D3DXVECTOR3> previousPositions;
  for (int i=0; i < 16; i++) {
    ppc = new PhysicsParticleCollection();
    float diam = 0.40f;
    float diamSq = diam*diam*3.0f;
    D3DXVECTOR3 particlePos;
    bool bColliding = true;
    int iterations = 0;
    while (bColliding && iterations < 1000) {
      particlePos = D3DXVECTOR3(4.0f*(float)rand()/RAND_MAX-2.0f, -3.50f-30.0f*(float)rand()/RAND_MAX, 0.0f);
      bColliding = false;
      for (std::vector<D3DXVECTOR3>::iterator itPrev=previousPositions.begin(); itPrev!=previousPositions.end(); itPrev++) {
        float distSq = D3DXVec3LengthSq(&((*itPrev)-particlePos));
        if (distSq < diamSq) {
          bColliding = true;
        }
      }
      iterations++;
    }
    previousPositions.push_back(particlePos);
    ppc->InitFromTexture(NULL, &particlePos, diam, diam, true, 2.0f);
    m_physicsParticleCollections.push_back(ppc);
  }

  for (int i=-30; i<30; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(i*0.15f, -0.50f, 0.0f), 0.10f, 0.10f, false, 4.0f);
    m_physicsParticleCollections.push_back(ppc);
  }

  for (int i=-12; i<10; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(i*0.15f, -2.0f-i*0.0f, 0.0f), 0.10f, 0.10f, false, 4.0f);
    m_physicsParticleCollections.push_back(ppc);
  }

  for (int i=-10; i<10; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(i*0.15f+2.0f, -4.0f-i*0.05f, 0.0f), 0.10f, 0.10f, false, 4.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
  


  for (int i=0; i<30; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(4.50f, -i*0.2f-0.5f, 0.0f), 0.10f, 0.10f, false, 4.0f);
    m_physicsParticleCollections.push_back(ppc);
  }
  for (int i=0; i<30; i++) {
    ppc = new PhysicsParticleCollection();
    ppc->InitFromTexture(NULL, &D3DXVECTOR3(-4.50f, -i*0.2f-0.5f, 0.0f), 0.1f, 0.10f, false, 4.0f);
    m_physicsParticleCollections.push_back(ppc);
  }


  ppc = new PhysicsParticleCollection();
  ppc->InitFromTexture(NULL, &D3DXVECTOR3(0.750f, -1.50f, 0.0f), 0.40f, 0.40f, true, 4.0f);
  m_physicsParticleCollections.push_back(ppc);

  ppc = new PhysicsParticleCollection();
  ppc->InitFromTexture(NULL, &D3DXVECTOR3(-0.50f, -1.50f, 0.0f), 0.40f, 0.40f, true, 4.0f);
  m_physicsParticleCollections.push_back(ppc);
*/



}


//  int m_keys[256];
//  int m_keysDown[256];
//  float m_keyDownTime[256];
bool EffectGameCubicle::HandleInput() {
  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();
  return true;
}


extern double PerfGetTickCount();


void GameCubicleLevel::Advance(float timeAbs, float timeStep) {

  double start = PerfGetTickCount();

  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();

  // advance tykki

  float changePowerSpeed = 1.0f;
  float moveSpeed = 3.0f;
  float moveAngleSpeed = 1.0f;

  if (cd->m_keysDown[65]) { // A
    if (m_moveMode == 0) {
      m_tykkiPos.x -= timeStep*moveSpeed;
    } else {
      m_tykkiAngle += timeStep*moveAngleSpeed;
    }
  }
  if (cd->m_keysDown[68]) { // D
    if (m_moveMode == 0) {
      m_tykkiPos.x += timeStep*moveSpeed;
    } else {
      m_tykkiAngle -= timeStep*moveAngleSpeed;
    }
  }
  if (cd->m_keysDown[87]) { // W
 //   m_tykkiPower += timeStep*changePowerSpeed;
      m_tykkiAngle += timeStep*moveAngleSpeed;
  }
  if (cd->m_keysDown[83]) { // S
 //   m_tykkiPower -= timeStep*changePowerSpeed;
      m_tykkiAngle -= timeStep*moveAngleSpeed;
  }
  if (cd->m_keysDown[VK_RETURN]==1) { // RETURN
 //   m_moveMode++;
    if (m_moveMode > 1) {
      m_moveMode = 0;
    }
  }

  m_tykkiPower = clamp(m_tykkiPower);

  D3DXVECTOR3 shootForce;
  shootForce = D3DXVECTOR3(0.0f, -m_tykkiPower, 0.0f);
  RotateByAngle(m_tykkiAngle+D3DX_PI, &shootForce);

  float blockFadeIn = 0.0f;
  if (m_pNextBlock) {
    blockFadeIn = 1.0f-clamp(m_pNextBlock->GetTimeFromInit()*1.0f);
    m_pNextBlock->SetSpeed(&D3DXVECTOR3(0.0f, 0.0f, 0.0f));
    m_pNextBlock->SetAngularSpeed(0.0f);
    m_pNextBlock->SetPosition(&(m_tykkiPos+D3DXVECTOR3(0.0f, -10.0f, 0.0f)*blockFadeIn));
    m_pNextBlock->SetAngle(m_tykkiAngle);
  }



  if ((blockFadeIn < 0.01f && cd->m_keysDown[VK_RETURN]==1) || m_pNextBlock==NULL) { // RETURN
  //  if (m_moveMode == 0) {
      // shoot
      if (m_pNextBlock) {
        m_pNextBlock->SetSpeed(&D3DXVECTOR3(0.0f, 0.0f, 0.0f));
        m_pNextBlock->SetAngularSpeed(0.0f);
        m_pNextBlock->SetIsDynamic();
        m_pNextBlock->CalculateCenter();
        m_pNextBlock->AddUniformImpulse(&(shootForce*m_tykkiPowerMax*(-1.0f)), timeStep);
        m_pNextBlock->UpdateParticleSpeedPos(true, timeStep);
      }

      PhysicsParticleCollection *ppc = new PhysicsParticleCollection();
      ppc->InitFromTexture(NULL, &m_tykkiPos, 0.80f, 0.20f, 0.125f, 16, 4, true, 1.0f, 0.0f);
      ppc->SetPosition(&D3DXVECTOR3(0.0f, -10.0f, 0.0f));
      m_physicsParticleCollections.push_back(ppc);
      m_pNextBlock = ppc;

  //  }
  }
 
  double tCCT = 0;
  double tCPF = 0;
  double tAPF = 0;
  double tCMC = 0;
  double tClearPF = 0;
  double tCreatePF = 0;

  double stCreatePF = PerfGetTickCount();
  for (std::vector<PhysicsParticleCollection*>::iterator it=m_physicsParticleCollections.begin(); it!=m_physicsParticleCollections.end(); it++) {
    (*it)->CalculateTotalMass();
  }
  m_physicsGrid.Clear();
  for (std::vector<PhysicsParticleCollection*>::iterator it=m_physicsParticleCollections.begin(); it!=m_physicsParticleCollections.end(); it++) {
    (*it)->AddParticlesToGrid(&m_physicsGrid);
  }
  std::map<PhysicsParticleCollection*, bool > mapColliding;

  double etCreatePF = PerfGetTickCount();
  tCreatePF = etCreatePF-stCreatePF;



  double stCCT = PerfGetTickCount();
  int biggestContactLevel = m_physicsGrid.CalculateContactDistances(&m_physicsParticleCollections);
  double etCCT = PerfGetTickCount();
  tCCT = etCCT-stCCT;

  double stCMC = PerfGetTickCount();
  m_physicsGrid.CalculateMinContactLevels();
  double etCMC = PerfGetTickCount();
  tCMC = etCMC-stCMC;


  // int numIter = 10;

  int numLevels=biggestContactLevel;
  for (int updateMode=0; updateMode<2; updateMode++) {
//    for (int updateMode=0; updateMode<2; updateMode++) {
    int numIter;
    if (updateMode == 0) { // update & iterate speeds
      numIter = 2;
    }
    if (updateMode >= 1) { // fix contacts & update the positions for this level
      numIter = 4;
    }
    for (int lev=1; lev<numLevels+1; lev++) {
      for (int i=0; i<numIter; i++) {
        float timeStep = m_physicsGrid.GetTimeStep();

        // updateMode
        // use candidate position for collision points & contact points
        // 0 - process collision (in case of collision, velocity reflecting force based on the elasticity), update velocity (gravity & external forces in) 
        // 1 - process contact (force to zero normal facing component of the velocity), update position (& candidate position with current velocity)

        double stClearPF = PerfGetTickCount();
        m_physicsGrid.ClearParticleForces(&m_physicsParticleCollections);
        double etClearPF = PerfGetTickCount();
        tClearPF += etClearPF-stClearPF;
        double stCPF = PerfGetTickCount();
        m_physicsGrid.CalculateParticleForces(&m_physicsParticleCollections, &mapColliding, i, numIter, lev, numLevels, timeStep, updateMode);
        double etCPF = PerfGetTickCount();
        tCPF += etCPF-stCPF;
        double stAPF = PerfGetTickCount();
        for (std::vector<PhysicsParticleCollection*>::iterator it=m_physicsParticleCollections.begin(); it!=m_physicsParticleCollections.end(); it++) {
          (*it)->ApplyForces(timeStep, 0.1f, updateMode, i, numIter, lev, numLevels);
        }
        double etAPF = PerfGetTickCount();
        tAPF += etAPF-stAPF;
      }
    }
  }
  double end = PerfGetTickCount();

  char tempStr[512];
  sprintf(tempStr, "%f CreateParticle Grid\n", tCreatePF);
  OutputDebugString(tempStr);
  sprintf(tempStr, "%f CalculateContactDistances\n", tCCT);
  OutputDebugString(tempStr);
  sprintf(tempStr, "%f CalculateMinContactLevels\n", tCMC);
  OutputDebugString(tempStr);
  sprintf(tempStr, "%f ClearParticleForces\n", tClearPF);
  OutputDebugString(tempStr);
  sprintf(tempStr, "%f CalculateParticleForces\n", tCPF);
  OutputDebugString(tempStr);
  sprintf(tempStr, "%f ApplyForces\n", tAPF);
  OutputDebugString(tempStr);
  sprintf(tempStr, "%f total\n", end-start);
  OutputDebugString(tempStr);
 
}


void EffectGameCubicle::Advance() {
  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();

  const EffectParam *epGame = GetPR()->get("game_cubicle");

  float timeStep = cd->m_timeStep;
  if (timeStep > 0.1f) {
    timeStep = 0.1f;
  }
  GameCubicleLevel *pLevel = m_levels[m_currentLevelIndex];
  pLevel->Advance(cd->m_timeFloat, timeStep);
}

void GameCubicleLevel::Render(D3DXMATRIXA16 *pMatView, D3DXMATRIXA16 *pMatProj) {
  std::string textureName;
  const EffectParam *ep = m_epGame->get("mesh", 0);
  Mesh *pMesh = g_D3DApp->getMesh(g_D3DApp->addAnimatedMesh(ep->getString("model").c_str(), NULL, NULL));
  Texture *tex1 = NULL;
  textureName = ep->getString("texture");
  if (strcmp(textureName.c_str(), "")!=0) {
    tex1 = g_D3DApp->addTexture(textureName.c_str());
  }
  const EffectParam *ep2 = m_epGame->get("mesh", 1);
  Texture *tex2 = NULL;
  textureName = ep2->getString("texture");
  if (strcmp(textureName.c_str(), "")!=0) {
    tex2 = g_D3DApp->addTexture(textureName.c_str());
  }
  Mesh *pMesh2 = g_D3DApp->getMesh(g_D3DApp->addAnimatedMesh(ep->getString("model").c_str(), NULL, NULL));

  D3DXMATRIXA16 wvp;

  bool bDrawParticles = false;

  const EffectParam *epSettings = m_epGame->get("settings");
  if (epSettings->getFloat("draw_particles") > 0.5f) {
    bDrawParticles = true;
  }

  std::vector<Light> *globalLights = GetGlobalLights();
  Light *pLight0 = NULL;
  Light light;
  if (globalLights->size()) {
    pLight0 = &(*globalLights)[0];
    light = *pLight0;
  }

  if (pMesh && pMesh2) {
    int numParticleCollectionsDrawn = 0;
    for (std::vector<PhysicsParticleCollection*>::iterator it=m_physicsParticleCollections.begin(); it!=m_physicsParticleCollections.end(); it++) {

      D3DXMATRIXA16 matWorld;
      g_D3DApp->MakeWorldMatrix(&matWorld,
                                (*it)->GetPosition(),
                                &((*(*it)->GetScale())*0.5f+D3DXVECTOR3(0.01f, 0.01f, 0.0f)),
                                &D3DXVECTOR3(0.0f, 0.0f, (*it)->GetCurrentAngle()/(2.0f*D3DX_PI)*360.0f));

      g_D3DApp->m_pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
      GetDeferred()->SetWorld(&matWorld);

      wvp = matWorld*(*pMatView)*(*pMatProj);
      GetDeferred()->SetWVP(&wvp);

      Texture *t = NULL;

      if (numParticleCollectionsDrawn & 1) {
        t = tex1;
      } else {
        t = tex2;
      }
/*
      for (unsigned int mi = 0; mi < pMesh->m_numMaterials; mi++) {
        g_D3DApp->m_pd3dDevice->SetMaterial(&pMesh->m_pMaterials[mi]);
        if (pMesh->m_ppTextures[mi] != NULL) {
          g_D3DApp->m_pd3dDevice->SetTexture(0, pMesh->m_ppTextures[mi]->lpTexture);
        }
        if (t) {
          g_D3DApp->setTexture(t, 0);
        }
        if (!bDrawParticles) {
          pMesh->m_pMesh->DrawSubset(mi);
        }
      }
*/
      if (!bDrawParticles) {
        /*
        if (pLight0 && (numParticleCollectionsDrawn&7)==0) {
          light.m_position.x = (*it)->GetPosition()->x*1.5f;
          light.m_position.y = (*it)->GetPosition()->y*2.0f+3.8f;
          light.m_position.z = (*it)->GetPosition()->z*1.5f+0.0f;
          light.m_position.w = 1.0f;
          AddToGlobalLights(&light);
        } else {
        */
          g_D3DApp->drawAnimatedMeshD(*pMesh, &matWorld, pMatView, pMatProj, NULL);
      //  }
      }

  

      numParticleCollectionsDrawn++;

      {
        Texture *t = NULL;
        std::string textureName = ep2->getString("texture");
        if (strcmp(textureName.c_str(), "")!=0) {
          t = g_D3DApp->addTexture(textureName.c_str());
        }
      }

      if (bDrawParticles) {
        for (std::vector<PhysicsParticle>::iterator itP=(*it)->m_physicsParticles.begin(); itP!=(*it)->m_physicsParticles.end(); itP++) {
          g_D3DApp->MakeWorldMatrix(&matWorld,
                                    (*itP).GetPosition(),
                                    &D3DXVECTOR3(0.01f, 0.01f, 0.010f), NULL);
                                    
          g_D3DApp->m_pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);
          GetDeferred()->SetWorld(&matWorld);

          wvp = matWorld*(*pMatView)*(*pMatProj);
          GetDeferred()->SetWVP(&wvp);
/*

          for (unsigned int mi = 0; mi < pMesh->m_numMaterials; mi++) {
            g_D3DApp->m_pd3dDevice->SetMaterial(&pMesh->m_pMaterials[mi]);
            if (pMesh->m_ppTextures[mi] != NULL) {
              g_D3DApp->m_pd3dDevice->SetTexture(0, pMesh->m_ppTextures[mi]->lpTexture);
            }
            if (t) {
              g_D3DApp->setTexture(t, 0);
            }
            pMesh2->m_pMesh->DrawSubset(mi);
          }
        */
          g_D3DApp->drawAnimatedMeshD(*pMesh2, &matWorld, pMatView, pMatProj, NULL);
        }
      }

// pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);

    }
  }


  if (m_pTykkiMesh) {


    textureName = m_epTykkiMesh->getString("texture");
    Texture *texTykki = NULL;
    if (strcmp(textureName.c_str(), "")!=0) {
      texTykki = g_D3DApp->addTexture(textureName.c_str());
    }

    D3DXMATRIXA16 matWorld;
    g_D3DApp->MakeWorldMatrix(&matWorld, &(m_tykkiPos+m_epTykkiMesh->getVec3("position")),
                              &(m_epTykkiMesh->getVec3("scale")+D3DXVECTOR3(m_tykkiPower, 0.0f, 0.0f)), &D3DXVECTOR3(0.0f, 0.0f, m_tykkiAngle*360.0f/(2.0f*D3DX_PI)));
                              
    g_D3DApp->m_pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    for (unsigned int mi = 0; mi < pMesh->m_numMaterials; mi++) {
      g_D3DApp->m_pd3dDevice->SetMaterial(&pMesh->m_pMaterials[mi]);
      if (pMesh->m_ppTextures[mi] != NULL) {
        g_D3DApp->m_pd3dDevice->SetTexture(0, pMesh->m_ppTextures[mi]->lpTexture);
      }
      if (texTykki) {
        g_D3DApp->setTexture(texTykki, 0);
      }
      m_pTykkiMesh->m_pMesh->DrawSubset(mi);
    }
  }
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectGameCubicle::Render() {
  DemoContextData *cd = (DemoContextData*)GetCurrentContextData();

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  const EffectParam *epGame;
  epGame = GetPR()->get("game_cubicle");

  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESS);


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;

  if (GetClearFlags()) {
    GetDeferred()->BeginDraw(true);
  } else {
    GetDeferred()->BeginDraw(false);
  }
  GetDeferred()->BeginShader();

  D3DXMatrixPerspectiveFovLH(&matProj, GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 0.10f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  matView = *GetGlobalCameraView();
  pd3dDevice->SetTransform(D3DTS_VIEW, &matView);
  GetDeferred()->SetView(&matView);

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);

  int numMesh = epGame->getN("mesh");

  for (int i=0; i<numMesh; i++) {

    const EffectParam *ep = epGame->get("mesh", i);
    Mesh *pMesh = g_D3DApp->getMesh(g_D3DApp->addAnimatedMesh(ep->getString("model").c_str(), NULL, NULL));
    if (!pMesh) {
      continue;
    }

    g_D3DApp->MakeWorldMatrix(&matWorld,
                              &(ep->getVec3("position")),
                              &(ep->getVec3("scale")),
                              &(ep->getVec3("rotate")));

    pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

    Texture *t = NULL;
    std::string textureName = ep->getString("texture");
    if (strcmp(textureName.c_str(), "")!=0) {
      t = g_D3DApp->addTexture(textureName.c_str());
    }
    GetDeferred()->SetWorld(&matWorld);
    wvp = matWorld*matView*matProj;
    GetDeferred()->SetWVP(&wvp);

    g_D3DApp->drawAnimatedMeshD(*pMesh, &matWorld, &matView, &matProj, NULL);

/*

    for (unsigned int mi = 0; mi < pMesh->m_numMaterials; mi++) {
      g_D3DApp->m_pd3dDevice->SetMaterial(&pMesh->m_pMaterials[mi]);
      if (pMesh->m_ppTextures[mi] != NULL) {
        g_D3DApp->m_pd3dDevice->SetTexture(0, pMesh->m_ppTextures[mi]->lpTexture);
      }
      if (t) {
        g_D3DApp->setTexture(t, 0);
      }
      pMesh->m_pMesh->DrawSubset(mi);
    }
    */

  }


  GameCubicleLevel *pLevel = m_levels[m_currentLevelIndex];
  pLevel->Render(&matView, &matProj);


  GetDeferred()->EndShader();
  GetDeferred()->EndDraw();

  // End the scene.
  pd3dDevice->EndScene();

  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  return 1;
}
