
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "D3DApp.h"
#include "common_globals.h"
#include "shader.h"
#include "deferred.h"

#include "EffectLayout.h"

#include "effect.h"
#include "EffectDof.h"

void EffectDof::Init() {
  if (!m_shader) {
    m_shader = new Shader();
  }
  m_shader->CreateFromFile(g_D3DApp->m_pd3dDevice, "shaders/dof.h");
}

void EffectDof::ReloadShaders() {
  Init();
}

bool EffectDof::CheckShadersModifiedOnDisk() {
  if (m_shader && m_shader->CheckModifiedOnDisk()) {
    return true;
  }
  return false;
}

void EffectDof::Advance() {
}

// renders all stuff belonging to the effect, can be called multiple times per frame
int EffectDof::Render() {
  // piirtoa

  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;

  const EffectParam *ep;
  ep = GetPR()->get("dof");


  Texture *pRtAtStart = g_D3DApp->GetPtrPrevSetRT();


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW);
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);

  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);

  int bits = ep->getInt("bits");
  
  Texture *rt16b_buffer0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_buffer0", 1, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);

  Texture *rt16b_depth = GetDeferred()->GetRT16bDepth();
  Texture *rt16b_normal = GetDeferred()->GetRT16bNormal();

  Texture *rt_bufferTemp0;
  Texture *rt_bufferTemp1;

  if (bits==8) {
    rt_bufferTemp0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt8b_bufferTemp0", 0, D3DFMT_A8R8G8B8); // D3DFMT_A16B16G16R16F);
    rt_bufferTemp1 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt8b_bufferTemp1", 0, D3DFMT_A8R8G8B8); // D3DFMT_A16B16G16R16F);
  } else if (bits==32) {
    rt_bufferTemp0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_bufferTemp0", 0, D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);
    rt_bufferTemp1 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_bufferTemp1", 0, D3DFMT_A32B32G32R32F); // D3DFMT_A16B16G16R16F);
  } else {
    rt_bufferTemp0 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_bufferTemp0", 0, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);
    rt_bufferTemp1 = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, "rt16b_bufferTemp1", 0, D3DFMT_A16B16G16R16F); // D3DFMT_A16B16G16R16F);
  }


  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_POINT );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_POINT );

  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_CLAMP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_CLAMP);


  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matWVP;

  D3DXMatrixIdentity(&matProj);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);
  pd3dDevice->SetTransform(D3DTS_VIEW, &matProj);
  pd3dDevice->SetTransform(D3DTS_WORLD, &matProj);
  D3DXMatrixIdentity(&matWorld);

  matWVP = matWorld*matProj*matProj;
/*
  // copy rt16b_buffer0 to rt16b_bufferTemp0
  g_D3DApp->resetRenderTarget();
  g_D3DApp->setTexture(rt16b_buffer0);
  g_D3DApp->setRenderTarget(rt16b_bufferTemp0);
  g_D3DApp->drawSquare(1.0f);
  g_D3DApp->resetRenderTarget();
  g_D3DApp->setRenderTarget(rt16b_buffer0);
  pd3dDevice->Clear( 0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_RGBA(0, 0, 0, 0), 1.0f, 0 );
*/
  m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );

  m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);

 //  g_D3DApp->setTexture(rt16b_buffer0);

  m_shader->GetEffect()->SetTexture("g_tDepth", rt16b_depth->lpTexture);
  m_shader->GetEffect()->SetTexture("g_tNormal", rt16b_normal->lpTexture);
  m_shader->GetEffect()->SetTexture("g_tDiffuse", rt16b_buffer0->lpTexture);

  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
 // pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
 // pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

  int blurLoops = ep->getInt("blur_loops");

  float blur_strength = ep->getFloat("blur_strength");
  float blur_strength_loop_add = ep->getFloat("blur_strength_loop_add");
  float current_pixel_weight = ep->getFloat("current_pixel_weight");

  m_shader->GetEffect()->SetFloat( "g_current_pixel_weight", current_pixel_weight);

  int numParams; 
  numParams = ep->getN("texture");
  for (int param=0; param<numParams; param++) {
    const EffectParam *epp = ep->get("texture", param);
    std::string name = epp->getString("shader_name");
    std::string file = epp->getString("file");
    Texture *tex = g_D3DApp->addTexture(file.c_str());
    m_shader->GetEffect()->SetTexture(name.c_str(), tex->lpTexture);
  }

  numParams = ep->getN("param");
  for (int param=0; param<numParams; param++) {
    const EffectParam *epp = ep->get("param", param);
    std::string name = epp->getString("shader_name");
    D3DXVECTOR4 value = epp->getVec4("value");
    m_shader->GetEffect()->SetVector(name.c_str(), &value);
  }



  m_shader->Enable();


  for (int lo=0; lo<blurLoops; lo++) {

    m_shader->GetEffect()->SetFloat( "g_blur_strength", blur_strength+lo*blur_strength_loop_add);
    float blurLoopNorm = 0.0f;
    if (blurLoops>1) {
      blurLoopNorm = (float)lo/(float)(blurLoops-1);
    }
    m_shader->GetEffect()->SetFloat( "g_blur_loop", blurLoopNorm);

    if ((lo & 1) == 0) {
    //  g_D3DApp->resetRenderTarget();
      if (lo!=0) {
        m_shader->GetEffect()->SetTexture("g_tDiffuse", rt_bufferTemp1->lpTexture);
      }
      if (lo!=blurLoops-1) {
        g_D3DApp->setRenderTarget(rt_bufferTemp0);
      } else {
        g_D3DApp->resetRenderTarget();
        if (pRtAtStart) {
          g_D3DApp->setRenderTarget(pRtAtStart, 0);
        }
      }
    } else {
    //  g_D3DApp->resetRenderTarget();
      if (lo!=0) {
        m_shader->GetEffect()->SetTexture("g_tDiffuse", rt_bufferTemp0->lpTexture);
      }
      if (lo!=blurLoops-1) {
        g_D3DApp->setRenderTarget(rt_bufferTemp1);
      } else {
        g_D3DApp->resetRenderTarget();
        if (pRtAtStart) {
          g_D3DApp->setRenderTarget(pRtAtStart, 0);
        }
      }
    }
    m_shader->Flush();
    g_D3DApp->drawSquare(1.0f);
  }
  m_shader->Disable();
  /*
  g_D3DApp->resetRenderTarget();
  g_D3DApp->setRenderTarget(rt16b_buffer0);
  */

  // End the scene.
  pd3dDevice->EndScene();

  return 1;
}
