// DemoContextData.h

class Layout;
class Timeline;
class Music;

struct sync_device;

class DemoContextData : public ContextData {
private:

 Timeline *m_timeline;

  float m_timelineTime;
  float m_timelineTimeStep;

  bool m_showTime;

  bool m_paused;
  bool m_musicPosNotSet;


public:
  DemoContextData(int index);
  ~DemoContextData();

  Music *m_demoMusic;
  Music *m_demoMusicAhead;


  bool appDoCleanup();
  HRESULT appCreateDeviceObjects();
  HRESULT appDestroyDeviceObjects();
  void appInput();
  bool appAdvance();
  HRESULT appRender();

  float GetTimelineTime() {
    return m_timelineTime;
  }
  void SetTimelineTime(float t) {
    m_timelineTime = t;
  }


  bool GetIsPaused() { return m_paused; }
  void SetPaused(bool b) { m_paused = b; }



};

sync_device *GetRocket();
void SetRocketRowRate(float bpm, int rpb);

FILETIME GetFileModifyTime(const char *fileName);