
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // new position
  float4 rt1 : COLOR1; // new velocity
  float4 rt2 : COLOR2; // 
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;

float g_time;
float g_timeStep;


texture g_tNoise;
sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = WRAP;
  AddressV = WRAP;
};

texture g_tPosPrev;
sampler smPosPrev =
sampler_state {
  Texture = <g_tPosPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVelPrev;
sampler smVelPrev =
sampler_state {
  Texture = <g_tVelPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVarPrev;
sampler smVarPrev =
sampler_state {
  Texture = <g_tVarPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

float4 rotateXZ(float4 p, float a) {
  float4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

float2 indexToCoords(float index, float width) {
  float2 tc;


  float k = index/width;
  tc.x = frac(k);
  tc.y = (k-tc.x)/width;
  return tc;
}

float coordsToIndex(float2 tc, float2 dim) {
  return tc.x*dim.x + (int)(tc.y*dim.y)*dim.x;
}

float4 turb(sampler s, float2 tc, int fr) {
  float4 r = float4(0.0, 0.0, 0.0, 0.0);
  float m = 0.50;
  for (int i=0; i<fr; i++) {
    r += (tex2D(s, tc)*2.0-1.0)*m;
    tc *= 2.0;
    m *= 0.5;
  }
  return r;
}

float4 g_boxSize;

float g_emitterRad;
float g_emitterDirSpeed;
float g_emitterRotate;

float g_emitterMove;
float g_emitterMoveSpeed;

float g_spread;

float g_spreadScale;
float g_spreadEvolve;

float g_maxAge;

float g_collisionAtt;


float4 g_grav;

PS_OUT ps_pixsim1( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float2 tcOfs = float2((+0.5)/g_windowWidth.x, (+0.5)/g_windowHeight);
  float4 pos = tex2D(smPosPrev, In.vTexcoord+tcOfs);
  float4 vel = tex2D(smVelPrev, In.vTexcoord+tcOfs);
  float4 var = tex2D(smVarPrev, In.vTexcoord+tcOfs);
  
  float pixIndex = coordsToIndex(In.vTexcoord, float2(g_windowWidth, g_windowHeight)); 

  
  int bInit = 0;
  
 float4 grav = g_grav; // float4(0.0, -0.500, 0.0, 0.0);
 // float4 grav = float4(0.0, -20.00, 0.0, 0.0);


  pos.w = pos.w - g_timeStep;

  if (pos.w < 0.01) { //  || pos.y < -30.0) {
    bInit = 1;
  } 


//  float4 noise = tex2D(smNoise,pos.xy*0.001)*2.0-1.0;
//  float4 noise = turb(smNoise, (pos.xy*0.12321+pos.z*0.13134)*0.001+g_time*float2(0.023, 0.011345)*0.00, 1);
  float4 noise = turb(smNoise, (pos.xy*0.12321+pos.z*0.13134)*0.1*g_spreadScale+g_time*float2(0.023, 0.011345)*g_spreadEvolve*0.050, 3);

 // vel.xyz += 0.020*(3.0+2500.0*saturate(sin(pixIndex*0.001+g_time*16.0)))*noise.xyz*g_timeStep;
 vel.xyz += noise.xyz*g_spread*g_timeStep;

 // vel *= 0.999;


  vel.w += 0.1*(1.57+atan(vel.y/(vel.z))-vel.w);

  vel.xyz += grav.xyz*g_timeStep;
  pos.xyz += vel.xyz*g_timeStep;

//  pos.x += 0.01;
  float diff;

  if (pos.x < -g_boxSize.x && vel.x < 0.0) {
    diff = -g_boxSize.x-pos.x;
    pos.x += diff;
    vel.x *= -g_collisionAtt;
  }
  if (pos.x > g_boxSize.x && vel.x > 0.0) {
    diff = pos.x-g_boxSize.x;
    pos.x -= diff;
    vel.x *= -g_collisionAtt;
  }
  if (pos.y < -g_boxSize.y && vel.y < 0.0) {
    diff = -g_boxSize.y-pos.y;
    pos.y += diff;
    vel.y *= -g_collisionAtt;
  }
  if (pos.y > g_boxSize.y && vel.y > 0.0) {
    diff = pos.y-g_boxSize.y;
    pos.y -= diff;
    vel.y *= -g_collisionAtt;
  }
  if (pos.z < -g_boxSize.z && vel.z < 0.0) {
    diff = -g_boxSize.z-pos.z;
    pos.z += diff;
    vel.z *= -g_collisionAtt;
  }
  if (pos.z > g_boxSize.z && vel.z > 0.0) {
    diff = pos.z-g_boxSize.z;
    pos.z -= diff;
    vel.z *= -g_collisionAtt;
  }
/*
  if (g_time < 19.60) {
    float2 tc = indexToCoords(pixIndex+g_time*0.01, g_windowWidth);
    float3 posPalloise;
    posPalloise.xyz =  tex2D(smNoise, tc)*2.0-1.0;
    posPalloise.xyz = normalize(posPalloise.xyz)*0.25;
    float lerps = g_time/19.60;
  //  vel.xyz *= 0.99;
    lerps = pow(lerps, 4.0)*0.25;
    posPalloise.xyz = posPalloise.xyz*(1.0-lerps) + pos.xyz*lerps;
    float4 kolo = float4(posPalloise, 0.0);
    kolo = rotateXZ(kolo, g_time*g_time*0.5);
    pos.xyz = kolo.xyz;
  }
  */

  if (bInit) {

    float4 result;
    float pf;
    
    pf = pixIndex*1.232321;

    float2 tc = indexToCoords(pixIndex+g_time*15342.5543, g_windowWidth);

    float4 noise2 = tex2D(smNoise, tc)*2.0-1.0;
    float4 noisePos = tex2D(smNoise, g_time*float2(1.234, 2.32325)*0.001*g_emitterMoveSpeed)*2.0-1.0;
    float4 noisePosPrev = tex2D(smNoise, (g_time-g_timeStep)*float2(1.234, 2.32325)*0.001*g_emitterMoveSpeed)*2.0-1.0;
    float4 noisePosVel = noisePos-noisePosPrev;
    result = noise2;

   // result.y = 0.0;

  //  result.
    result.xz = In.vTexcoord;
    result.xz -= 0.5;

   // result.x *= 0.4;
    result.y = 0.0;


   // result = tex2D(smNoise, In.vTexcoord+tcOfs+indexToCoords(pixIndex+g_time))*2.0-1.0;
    result *= 2.0;


    pf = 0.0; // pixIndex*0.001;


    result.w = 1.0;

    vel.xyz = noise2.xyz*0.20*g_emitterRad;
    vel.y += 0.50;

    vel = rotateXZ(vel, g_emitterRotate);

    int pixIndexI = (int)(pixIndex*0.001);

   // pos = float4(0.0+frac(pixIndex*0.01)*1.0, -20.0+frac(pixIndex*0.02345)*1.0, 0.0, 2.0+(float)pixIndex*2.0/10000.0);
    pos = float4(result.x+noise2.x, 0.0+result.y+noise2.y, result.z, 0.0)*0.02*g_emitterRad;
    pos.w = (noise2.z+1.0)*g_maxAge;
    noisePos.x *= g_boxSize.x;
    noisePos.y *= g_boxSize.y;
    noisePos.z *= g_boxSize.z;
    pos.xyz += noisePos.xyz*0.350*g_emitterMove;

    pos.xyz += noisePosVel*3.250*g_emitterDirSpeed;
 //   pos.xyz = noise.xyz;
 //   pos = float4(0.0, -20.0, 0.0, 2.0+(float)pixIndex*2.0/1000.0);

    var = float4(2.0, 0.0, 0.0, 1.0); // time to live
  }

 // pos.r = g_time*0.01;
 // pos.g = g_timeStep;
  
 // pos = noise;

 // pos.xy = In.vTexcoord*10.0;
 // pos.z = 0.0;
 // pos.w = 1.0;

  o.rt0 = pos;
  o.rt1 = vel;
  o.rt2 = var;
  
  return o;
} 



technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps_pixsim1( );
    }
}

