
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float g_time;


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  o.vTexcoord = (v.vTexcoord); 
 
  return o;
}

struct PS_OUT {
  float4 rt0 : COLOR0; 
};

texture g_tDiffuse;
sampler smDiffuse =
sampler_state {
  Texture = <g_tDiffuse>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = MIRROR;
  AddressV = MIRROR;
};

texture g_tVignette;
sampler smVignette =
sampler_state {
  Texture = <g_tVignette>;
  MipFilter = LINEAR;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = MIRROR;
  AddressV = MIRROR;
};



float g_amount = 1.0;
float4 g_color;

float g_zoom_x;
float g_zoom_y;

float g_speed_x;
float g_speed_y;


PS_OUT ps( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float2 tcOfs = float2(0.50/g_windowWidth, 0.50/g_windowHeight-(g_time-105.0)*0.0+0.2);

  float ka = tcOfs.y+In.vTexcoord.y;
  ka = frac(ka*2.0)*2.0;
  //if (ka<1.0) {
  //  discard;
  //}
  
 float k = sin(cos(g_time*g_time)*g_time);
  k = pow(k,4.0);
  float4 r = (1.0+k*0.6)*tex2D(smDiffuse, In.vTexcoord+tcOfs);
 // float4 v = tex2D(smVignette, In.vTexcoord*1.0+tcOfs);
  float2 tcVign = (In.vTexcoord*1.0-float2(0.0, 0.0));
  float3 res = float3(0.0, 0.0, 0.0);
  float zoom_x = g_zoom_x;
  float zoom_y = g_zoom_y; 
  float speed_x = g_speed_x;
  float speed_y = g_speed_y;
  
  tcVign.y *= -1.0;
  tcOfs.y -= (g_time-105.0)*0.02;
//  r=r*(1.0-pow(v,4.0)*4);
//  r=r*v;

  float kgb=1.0;
  float aa=1.0;
  float a=1.0;
  for (int i=0; i<1; i++) {
  	  tcVign -= float2(0.5, 0.5);
	  tcVign.x *= zoom_x;
	  tcVign.y *= zoom_y;
	  tcVign += float2(0.5, 0.5);
	  tcVign.x += speed_x*g_time;
	  tcVign.y += speed_y*g_time;
	  
  float ka = tcVign.y+tcOfs.y;
  ka = frac(ka*0.30)*2.0;
  /*
  if (ka<0.40) {
  //  i++;
  //  a*=0.15;
    discard;
  }	  */
   float fades=1.0;
    if ((tcVign.y+tcOfs.y > 1.0) || (tcVign.y+tcOfs.y < 1.0)) {
	  fades=0.0;
	}
	  res += 0.5*((1.0-g_amount)+a*g_amount*tex2D(smVignette, tcVign+tcOfs).xyz);
	  /*
	  float3 ko = tex2D(smVignette, In.vTexcoord*kgb)*1.2;
	  ko.r*=1.2;
	  res += ko;
	  ko = tex2D(smVignette, In.vTexcoord*kgb*1.03)*1.2;
	  ko.g*=1.1;
	  res += ko;
	  kgb *=1.02;
	  aa+=a;
	  a*=0.53;
	  */
	  zoom_x *= 0.250;
	  zoom_y *= 0.250;
	  speed_x *= -1.0;
	  speed_y *= -1.0;
  }
  r.xyz *= res/aa;
//  r.x = 1.0;
  o.rt0 = r;
  return o;
}
/*
PS_OUT ps( VS_OUTPUT In ) {
  PS_OUT o = (PS_OUT)0;
  
  float2 tcOfs = float2(0.50/g_windowWidth, 0.50/g_windowHeight);
  float4 r = tex2D(smDiffuse, In.vTexcoord*1.0+tcOfs);
  float4 v = tex2D(smVignette, In.vTexcoord*1.0+tcOfs);
//  r=r*(1.0-pow(v,4.0)*4);
  r=r*v; // multiple
  r=r-v; // subtract
  r=r+v; // add
  
  o.rt0 = r;
  return o;
}
*/
technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs();
        PixelShader  = compile ps_3_0 ps();
    }
}

