
float4x4 g_mWorldViewProjection;    

float g_luminosity;
float g_whiteness;

float g_windowWidth;
float g_windowHeight;

float2 g_texCoordScale;
float2 g_texCoordOfs;

float4 g_color;

struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};


VS_OUTPUT vs_float_to_onezero( const VS_INPUT v ) {
  VS_OUTPUT o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  float2 correcter = float2((g_windowWidth-1)/g_windowWidth, (g_windowHeight-1)/g_windowHeight);
  o.vTexcoord = ((v.vTexcoord)*correcter+float2(1.0/g_windowWidth, 1.0/g_windowHeight))*g_texCoordScale+g_texCoordOfs; 
//  o.vTexcoord = (1.0-float2(-o.vPosition.x-1.0/g_windowWidth, o.vPosition.y-1.0/g_windowHeight))*0.50*correcter;
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // final mixed image
};

texture tex0;

sampler sm =
sampler_state {
  Texture = <tex0>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
  AddressU = MIRROR;
  AddressV = MIRROR;
};

PS_OUT ps_kuva( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
//  float2 b = float2(0.0, 4.0);
  
  result += tex2D(sm, In.vTexcoord);

  result = clamp(result*1.0, 0.0, 100000.0)*g_color;
  
 
  o.rt0 = result;
  return o;
}

float4 g_blurSize;
float4 g_blurDisp;
float4 g_blurDispRGB;

int g_numSamples;

PS_OUT ps_kuva_blur_line( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float a = 0;
  
  float2 d = 2.0*g_blurSize.xy/(g_numSamples-1);
  float2 pos = In.vTexcoord-g_blurSize.xy;
 
  for (int i=0; i<g_numSamples; i++) {
    result += tex2D(sm, pos)*(i+1);
    pos += d;
    a += 1.0*(i+1);
  }

  result = clamp(result/a, 0.0, 100000.0)*g_color;
  
  o.rt0 = result;
  return o;
}


PS_OUT ps_kuva_blur_line_disp( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float a = 0;
  
  float2 d = 2.0*g_blurSize.xy/(g_numSamples-1);
  float2 pos = In.vTexcoord-g_blurSize.xy;


  for (int i=0; i<g_numSamples; i++) {
    float4 kola;
    
    kola = tex2D(sm, pos);
    result += kola*(i+1);
    pos += d*(dot(kola, g_blurDispRGB)+1.0); // g_blurDisp.x);

    a += (i+1);
  }

  result = clamp(result/a, 0.0, 100000.0)*g_color;
  
  o.rt0 = result;
  return o;
}



PS_OUT ps_kuva_blur_line_disp_rgb( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float a = 0;
  
  float2 d = 2.0*g_blurSize.xy/(g_numSamples-1);

  float2 posR = In.vTexcoord-g_blurSize.xy;
  float2 posG = In.vTexcoord-g_blurSize.xy;
  float2 posB = In.vTexcoord-g_blurSize.xy;
  
  for (int i=0; i<g_numSamples; i++) {
    float4 kola=(float4)0;
    kola.r = tex2D(sm, posR).r;
    posR += d*(kola.r*g_blurDispRGB.x+g_blurDisp.x);
    kola.g = tex2D(sm, posG).g;
    posG += d*(kola.g*g_blurDispRGB.y+g_blurDisp.y);
    kola.b = tex2D(sm, posB).b;
    posB += d*(kola.b*g_blurDispRGB.z+g_blurDisp.z);

    result += kola*(i+1);
    a += (i+1);
  }

  result = clamp(result/a, 0.0, 100000.0)*g_color;
  
  o.rt0 = result;
  return o;
}



PS_OUT ps_kuva_blur_xy( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float a = 0;
  
  float2 d = 2.0*g_blurSize.xy/(g_numSamples-1);
  float2 pos;
  
  for (int y=0; y<g_numSamples; y++) {
    for (int x=0; x<g_numSamples; x++) {
      pos = (In.vTexcoord-g_blurSize.xy)+float2(x, y)*d;
      result += tex2D(sm, pos);
      a += 1.0;
    }
  }

  result = clamp(result/a, 0.0, 100000.0)*g_color;
  
  o.rt0 = result;
  return o;
}



PS_OUT ps_kuva_blur_xy_disp_rgb( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  
  float4 result = 0;
  
  float a = 0;
  
  float2 d = 2.0*g_blurSize.xy/(g_numSamples-1);

  float2 posR = (In.vTexcoord-g_blurSize.xy);
  float2 posG = (In.vTexcoord-g_blurSize.xy);
  float2 posB = (In.vTexcoord-g_blurSize.xy);
  
  
  for (int y=0; y<g_numSamples; y++) {
    posR.x = In.vTexcoord.x - g_blurSize.x;
    posG.x = In.vTexcoord.x - g_blurSize.x;
    posB.x = In.vTexcoord.x - g_blurSize.x;

    float4 kola=0;

    
 
    for (int x=0; x<g_numSamples; x++) {
      
      kola.r = tex2D(sm, posR).r;
      posR.x += d*(kola.r*g_blurDispRGB.x+g_blurDisp.x);
      
      kola.g = tex2D(sm, posG).g;
      posG.x += d*(kola.g*g_blurDispRGB.y+g_blurDisp.y);
      
      kola.b = tex2D(sm, posB).b;
      posB.x += d*(kola.b*g_blurDispRGB.z+g_blurDisp.z);
      
      result += kola*(x*y+1);
      a += (x*y+1);
    }
    
    posR.y += d*(kola.r*g_blurDispRGB.x+g_blurDisp.x);
    posG.y += d*(kola.g*g_blurDispRGB.y+g_blurDisp.y);
    posB.y += d*(kola.b*g_blurDispRGB.z+g_blurDisp.z);    
    
  }  
  
  result = clamp(result/a, 0.0, 100000.0)*g_color;
  
  o.rt0 = result;
  return o;
}



technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_kuva( );
    }
}


technique RenderBlurLine {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_kuva_blur_line( );
    }
}


technique RenderBlurLineDisp {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_kuva_blur_line_disp( );
    }
}


technique RenderBlurLineDispRGB {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_kuva_blur_line_disp_rgb( );
    }
}

technique RenderBlurXYDispRGB {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_kuva_blur_xy_disp_rgb( );
    }
}


technique RenderBlurXY {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_float_to_onezero( );
        PixelShader  = compile ps_3_0 ps_kuva_blur_xy( );
    }
}


