#version 150
layout(points) in;
layout(points, max_vertices = 10) out;

in vec4 geopos[];
in vec4 opos[];
out vec4 pos;
out float size;
uniform float visibility;

void main() {
		gl_Position = geopos[0];
		pos = opos[0];
		gl_PointSize = max(2.0f,min(64.0f,20*visibility/(geopos[0].z*0.1f)));
		size = gl_PointSize;
		EmitVertex();
	EndPrimitive();
}
