;********************************************
;* Stardust by Rachy/Methabolix
;* (c) 2009
;*
;* Released to limiTED 2 competition
;* http://plus4world.powweb.com/features/limiTED2
;*
;* Compile with A6 (by Simon Collis):
;* a6 -fp -s2 -t stardust.asm
;********************************************

;********************************************
;* Memory map
;*
;* $0002-$003f System stuff (some free)
;* $0040-$004f Animation: positions
;* $0050-$005f Animation: directions
;* $0060-$006f Animation: size
;* $0070-$007f Animation: speed
;* $0080-$008f Animation: frame counters
;* $0090-$00bf System stuff (some free)
;* $00c0-$00cf Animation: wait counters
;* $00d0       reg_ff13
;* $00d1       reg_ff06
;* $00d2       reg_ff12
;* $00d3       stage marker
;* $00d4-$00d5 scrptr1
;* $00d6-$00d7 scrptr2
;* $00d8-$00d9 charptr
;* $00da
;* $00db-$00dc anim_frame_ptr
;* $00dd       anim_last
;* $00de       copycount
;* $00df-$00e0 copysrc
;* $00e1-$00e2 gfxptr
;* $00e3-$00e4 gfxptr2
;* $00e5-$00e6 animpos
;* $00e7       *** Free
;* $00e8-$00ef System stuff (some free)
;* $0800-$0fff Screen memory
;* $1000-$17ff Program and data area
;* $1800-$1fff Graphic screen color memory (don't touch, not preserved!)
;* $2000-$3fff Hires graphic screen (don't touch, not preserved!)
;* $4000-$47ff Charset: stars, size: 1
;* $4800-$4fff Charset: stars, size: 2
;* $5000-$57ff Charset: stars, size: 3
;* $5800-$5cff Charset: logo
;* $5d00-$6fff ** Free
;* $7000-$77ff Charset: drawing stage 1
;* $7800-$7fff Charset: drawing stage 2
;* $8000-$efff *** Free (only in ROM disabled mode or for charsets)
;* $f000-$fc00 BASIC variable area (don't touch, not preserved!)
;* $fd00-$ff3f System stuff
;* $ff40-$fff5 ** Free
;* $fff5-$ffff Reset and IRQ handler
;********************************************

;Kernel functions
PRINT		= $ff4f
CURPOS		= $fff0
WINTOPLEFT	= $de7a
FILLPAGES	= $c5a7		;X=number of pages, y=higher part of the start page; A=value
RUNINIT		= $8bbe
RUN		= $8bdc
RELINKPRG	= $8818

zpstart		= $d0	;First zero page variable address
zpmax		= $0a	;Max zero page variable number

reg_ff13	= $d0	;TED register mirrors for IRQ
reg_ff06	= $d1
reg_ff12	= $d2
stage		= $d3	;Actual position pointer in charset
scrptr1		= $d4	;Screen build pointer 1
scrptr2		= $d6	;Screen build pointer 2
charptr		= $d8	;Actual position pointer in charset

anim_frame_ptr	= $db	;Animation: frame base pointer
anim_last	= $dd	;Last item in the animation (temporary storage)
gfxptr		= $e1	;Graphic pointer for copying it into charset
gfxptr2		= $e3	;Additional graphic pointer for copying it into charset

animpos		= $e5	;Position in the animation of an item
copysrc		= $df	;Source for memory copy
copydest	= $e1	;Destination for memory copy
copycount	= $de	;Page counter for memory copy


variablespace	= $f000	;Start of BASIC variable space
anim_max	= 11	;Animation: maximum numbers of items-1

anim_wait	= $c0 ;Animation: wait counters
anim_pos	= $40 ;Animation: positions
anim_direction	= $50 ;Animation: directions
anim_size	= $60 ;Animation: size
anim_speed	= $70 ;Animation: speed
anim_frame	= $80 ;Animation: frame counters


starchars	= $4000	;Star charset start
logochars	= $6800 ;Logo charset start
;* Stage charset must follow logo charset!
;* DO NOT separate, initialization is done in one round for both!
drawchars1	= $7000 ;Charset for drawing stage 1
drawchars2	= $7800 ;Charset for drawing stage 2

rotation	= $0a	;Vector rotation value
zoom		= $09	;Vector zoom value (5 - no zoom ... 0 - min size)

tmp		= $a8	;Temporary storage
counter		= $aa	;Counter for anything
counter2	= $ab	;Counter for anything
timer		= $ac	;Timer decremented by the IRQ routine

;********************************************
;BASIC list: SYS4179 (jump to start label)
;********************************************

.org	$1001
.byte	$0a,$10,$D7,$07,$9E,$34,$31
.byte	$37,$39
.byte	$00,$00,$00

;********************************************
;Program starts
;********************************************

*=$100d
continue
	jmp starcont	;The returning point from BASIC, must be set to the actual value

;--- Data for vector items
EOL	=	255

vectors
; Star
	.byte	20,	0,	24,	14,	39,	14,	27,	22
	.byte	32,	36,	20,	28,	8,	36,	12,	22
	.byte	0,	14,	16,	14,	20,	0,	EOL,	0
	.byte	19,	20,	EOL

;--- Data for animations
; Star - rotating
staranim1
	.word	0,200,400,600,800,1000,1200,1400,1600,EOL
staranim2
	.word	1600,1400,1200,1000,800,600,400,200,0,EOL

;--- Start of the main program
;--- DO NOT put anything between the Star data and the start of the program!
start
;--- Init zero page variables
	.local
	ldx #$0
;---!!!! HACK
	stx $2d		;Lower byte of variable space is always 0
;---!!!! HACK
cyc	lda zpsetup,x
	sta zpstart,x
	inx
	cpx #zpmax
	bne cyc
	.endloc

;--- Set up environment

	lda #0		;Clear stage and logo charset
	ldx #16
	ldy #>logochars
	jsr FILLPAGES

;--- Set up screen
	lda #$0d	;Background color is same as normal bg color
	ldx #3
	ldy #$08
	jsr FILLPAGES
	lda #$00	;Logo color
	ldx #1
	ldy #$0b
	jsr FILLPAGES
	ldx #4		;Inverse space fill for stage and logo
	ldy #$0c
	lda #$a0
	jsr FILLPAGES

;--- Logo printing
	.local
	ldx #08		;Position for window on screen: [8,20]
	lda #20
	jsr WINTOPLEFT
	jsr PRINT	;Print logo into the window
	.byte	$13	;HOME
	.byte	$90	;black color
	.incbin "stardust_medium_ascii.bin"
	.byte 0
	.endloc

;--- Set up screen drawing stage
	.local
	ldx #$0
cyc2	ldy #$0
cyc	lda #$2d
	sta (scrptr1),y
	txa
	sta (scrptr2),y
	clc
	adc #16
	tax
	iny
	cpy #16
	bne cyc
	inx
	stx tmp
	lda #40
	ldx #scrptr1
	jsr incptr
	lda #40
	ldx #scrptr2
	jsr incptr
	ldx tmp
	cpx #16
	bne cyc2
	
	.endloc	

;--- Initialize animation
	.local
	ldx #anim_max
cyc
;---!!!! HACK
	lda #0		;This hack hijacks the iteration to fill up with
	sta $0af8,x	;black color a few characters on the screen
;---!!!! HACK
	lda $d000,x	;Pseudo random: reading from ROM
	sta anim_wait,x
	dex
	bpl cyc
	.endloc

;--- Set up BASIC prg

	lda #<basiccode	;Start of BASIC prg
	sta $2b
	lda #>basiccode
	sta $2c	

	lda #>variablespace
	sta $2e

	jsr RELINKPRG	;Reconstruct line linking in BASIC prg

	lda #$ff	;Tricking system into thinking
	sta $75		;that GRAPHIC command already relocated the
			;BASIC program

;--- Set up IRQ
	sei		;just to be safe, starting BASIC program will enable it again anyway
	ldx #<irq1
	ldy #>irq1
	stx $0314
	sty $0315

;--- Draw stars
	lda #3
	sta zoom

starnewzoom
	lda #0
	sta rotation

;--- Draw the vectors
; Rotation and zoom must be set
draw
	jsr RUNINIT
	jmp RUN

starcont
	jsr copytochar
	lda #8
	clc
	adc rotation
	sta rotation
	cmp #72
	bne draw

	lda #<starchars
	sta charptr
	inc charptr+1
	dec zoom
	bne starnewzoom

afterstars	

;--- Start of animation
animmaincyc
	lda #4		;Initialize timer: wait for 4 screenrefreshes
	sta timer

	lda #0		;Clear screen
	ldx #8
	ldy stage
	jsr FILLPAGES

	ldx #anim_max

ancyc	lda anim_wait,x
	bmi animmove
	dec anim_wait,x
ancyc2	dex
	bpl ancyc

animfinished
	lda stage	;Switch stages
	sta reg_ff13
	eor #8
	sta stage

waittimercycle
	lda timer
	bne waittimercycle
	beq animmaincyc
;-----------
animmove
	cmp #$ff	;Fresh anim: not inited yet
	bne noinit
	dec anim_wait,x	;Init anim
	sta anim_pos,x
	lda $ff02
	and #$20
	sta anim_direction,x
	lda $ff00
	and #$03
	tay
	lda anim_size_list,y
	sta anim_size,x
	lda #0
	sta anim_frame,x

noinit
	inc anim_pos,x
	lda anim_pos,x	;Final position?
	cmp #88
	bne posok

	lda $ff00	;Set up next anim (random)
	eor $ff1d
	and #$7f
	sta anim_wait,x

posok

;--- Drawing item
animdraw
	stx anim_last

	lda anim_frame,x
	asl
rereadframe
	tay
	inc anim_frame,x
	lda anim_direction,x
	beq clockwise
	lda #<staranim2
	bne animptrwrite
clockwise
	lda #<staranim1
animptrwrite
	sta anim_frame_ptr
	lda #>staranim1		;Cheating here: assuming that only the
				;low byte is different in this address
	sta anim_frame_ptr+1
	ldx anim_last

	lda (anim_frame_ptr),y
	cmp #EOL
	bne animframeok
	lda #0
	sta anim_frame,x
	beq rereadframe

animframeok
	sta charptr
	iny
	lda (anim_frame_ptr),y
	clc
	adc anim_size,x
	sta charptr+1

	lda anim_collow,x
	clc
	adc anim_pos,x
	sta gfxptr
	lda anim_colhi,x
	adc stage
	sta gfxptr+1

	jsr copytoscr
	ldx anim_last
	jmp ancyc2

;--- Copies the drawn object into the following position in the charset
; Parameters: X,Y - memory address for starting copy
copytochar
	.local
	ldx #$00
	ldy #$20
	stx gfxptr2
	sty gfxptr2+1
	lda #5
	sta counter2
chrcyc3
	lda gfxptr2
	sta gfxptr
	lda gfxptr2+1
	sta gfxptr+1
	lda #5
	sta counter
chrcyc2
	ldy #0
chrcyc	lda (gfxptr),y
	sta (charptr),y
	iny
	cpy #8
	bne chrcyc
	tya
	ldx #charptr
	jsr incptr
	inc gfxptr+1	;Next line: 320 = 256+64
	lda #64
	ldx #gfxptr
	jsr incptr
	dec counter
	bne chrcyc2
	lda #8
	ldx #gfxptr2
	jsr incptr
	dec counter2
	bne chrcyc3
	rts
	.endloc

;--- Copies the drawn object into the stage
;--- Parameters x/y: target screen position as memory address
copytoscr
	.local
	lda #$5
	sta counter
chrcyc2
	ldy #0
chrcyc	lda (gfxptr),y
	ora (charptr),y
	sta (gfxptr),y
	iny
	cpy #40
	bne chrcyc
	tya
	ldx #charptr
	jsr incptr
	lda #128	;Next row: 128
	ldx #gfxptr
	jsr incptr
	dec counter
	bne chrcyc2
	rts
	.endloc

;--- Increment a zero page pointer
; Parameters: A - value to be added, X - pointer start address
; Returns: A - higher byte of the ptr
; Uses: X
incptr
	clc
	adc $0,x
	sta $0,x
	inx
	lda #0
	adc $0,x
	sta $0,x
	rts

;--- IRQ routine
;Used via $0314-$0315, ROM must not be disabled!
irq1	asl $ff09

	ldx #$00

	ldy #$9c
irqcyc3	cpy $ff1d
	bne irqcyc3

	lda #$08
	sta $ff07

	lda #>logochars
	ldy #$a0
irqcyc	cpy $ff1e
	bcs irqcyc

	stx $ff19
	sta $ff13
	stx $ff12


	lda #$78
	sta $ff15

	lda #$08
	sta $ff14

	lda #$d1
	ldx #<irq2
	ldy #>irq2

	bne irqend

irq2	asl $ff09

	ldx #$0d
	ldy #$b8
irqcyc2	cpy $ff1e
	bcs irqcyc2
	stx $ff19
	stx $ff15

	lda #$88
	sta $ff07

	lda reg_ff13
	sta $ff13

	lda reg_ff12
	sta $ff12
	lda reg_ff06
	sta $ff06

	dec timer

	.local
cyc	ldx $ff00	;Copy charset from ROM to RAM at random positions
	lda $d200,x
	and $ff03
	sta logochars+$0200,x
	lda $d300,x
	and $ff03
	sta logochars+$0300,x
	.endloc

	lda #$98
	ldx #<irq1
	ldy #>irq1

irqend	sta $ff0b
	stx $0314
	sty $0315

	jmp $fcbe

;---------- Animation data ----------
colwidth	= 16*8
anim_collow
	.byte <colwidth*0
	.byte <colwidth*1
	.byte <colwidth*2
	.byte <colwidth*3
	.byte <colwidth*4
	.byte <colwidth*5
	.byte <colwidth*6
	.byte <colwidth*7
	.byte <colwidth*8
	.byte <colwidth*9
	.byte <colwidth*10
	.byte <colwidth*11

anim_colhi
	.byte >colwidth*0
	.byte >colwidth*1
	.byte >colwidth*2
	.byte >colwidth*3
	.byte >colwidth*4
	.byte >colwidth*5
	.byte >colwidth*6
	.byte >colwidth*7
	.byte >colwidth*8
	.byte >colwidth*9
	.byte >colwidth*10
	.byte >colwidth*11

anim_size_list
	.byte >starchars
	.byte >starchars+$800
	.byte >starchars+$1000
	.byte >starchars+$1000

;---------- Stardust logo ----------
logo
;	.incbin "stardust_inverted_medium.bin"

;--- Data for zero page variables default setup

zpsetup
	.byte >drawchars1	;reg_ff13
	.byte $1b		;reg_ff06
	.byte $00		;reg_ff12
	.byte >drawchars2	;stage marker
	.word $080c		;scrptr1
	.word $0c0c		;scrptr2
	.word starchars		;charptr

;---------- BASIC drawing program ----------
	.byte 0		;don't remove, required by the BASIC code
basiccode
	.incbin "plotter.bin"

;*** EOF
