uniform float Time;
uniform float PointSize;

attribute vec3 Velocity;
attribute float StartTime;

varying vec4 Color;
varying float disc;
varying vec2 TexCoord;

void main( void ) {

    vec4 vert;
    float t = Time - StartTime;
    if(t >= 0.0)
    {
        vert = gl_Vertex + vec4(Velocity*t,0.0);
        vert.y -= 0.0001*t*t;
        float dist = -(gl_ModelViewMatrix*vert).z;
        gl_PointSize = PointSize/dist;
        if(dist < 2.0) Color = gl_FrontMaterial.diffuse*(dist-1.0);
        else Color = gl_FrontMaterial.diffuse;
        disc = 0.0;
    }
    else
    {
        vert = gl_Vertex;
        //Color = vec4(0.0);
        disc = 1.0;
    }
    gl_Position = gl_ModelViewProjectionMatrix*vert;
}
