float4x4 matWorldViewProjection; 
float4x4 matWorld; 
float4x4 matView;

float3 Light = {0.f, 10.f, 10.f};
float3 color = {0.f, 1.f, 0.f}; 
float FogEnd = 400.f;
float FogStart = 0.f;


void vs_diffuse(in float4 ipos : POSITION,
                in float3 inormal : NORMAL,
                out float4 opos : POSITION,
                out float3 onormal : TEXCOORD0,
                out float3 lightvec : TEXCOORD1,
                out float  fog : TEXCOORD2)
 {
    opos = mul(ipos, matWorldViewProjection); 
    onormal =  (mul(inormal, matView)); 
    lightvec = normalize( Light - mul(float4(ipos.xyzw), matWorld)); 
    fog = 1.f-clamp( (length(Light -mul(float4(ipos.xyz, 1.f), matWorld))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);
 }
 
 float4 ps_diffuse(in float3 normal : TEXCOORD0,
                   in float3 lightvec : TEXCOORD1,
                   in float fog : TEXCOORD2) : COLOR0
{
    float ndotl = normalize(dot(normalize(normal), lightvec)); 

//	return float4(normal, 1.f);
	return float4(lightvec, 1.f);

    return float4(color*ndotl, 1.f); 
}

technique diffuselight
{
    pass diffse
    {
        vertexshader = compile vs_2_0 vs_diffuse();
        pixelshader  = compile ps_2_0 ps_diffuse();
    }
    
    pass fog
    {
        vertexshader = compile vs_2_0 vs_diffuse();
        pixelshader = compile ps_2_0 ps_diffuse();
    }
}
 