float4x4 matProjection; 

float radius = 1.f;
float2 offset = {1.f/800.f, 1.f/450.f};

texture tex0; 
sampler2D base = sampler_state
{
	texture = (tex0);
	AddressU = Clamp; AddressV = Clamp;
	MagFilter = Linear; MinFilter = Linear; MipFilter = Linear;
};


void vs_guassian(in float4 ipos : POSITION,
				 in float2 itex : TEXCOORD0,
				 out float4 opos : POSITION,
				 out float2 otex : TEXCOORD0,
				 out float2 rf : TEXCOORD1,
				 out float2 lf : TEXCOORD2)
{
	opos = mul(ipos, matProjection);
	otex = itex+offset/2.f;
	offset*=radius;
	rf.x = otex.x+offset.x;
	rf.y = otex.y+offset.y;
	lf.x = otex.x-offset.x;
	lf.y = otex.y-offset.y;
}

float4 ps_guassian(in float2 itex : TEXCOORD0,
				   in float2 rf : TEXCOORD1,
				   in float2 lf : TEXCOORD2) : COLOR0
{ 
	float4 p = tex2D(base, itex) + 
			   tex2D(base, float2(rf.x, itex.y)) + 
			   tex2D(base, float2(lf.x, itex.y)) +
			   tex2D(base, float2(itex.x, rf.y)) +
			   tex2D(base, float2(itex.x, lf.y)) +
			   tex2D(base, float2(lf.x, lf.y)) +
			   tex2D(base, float2(rf.x, lf.y)) + 
			   tex2D(base, float2(rf.x, rf.y)) +
			   tex2D(base, float2(lf.x, rf.y));
	return p/9.f; 
}


technique guassian
{
	pass base
	{
		vertexshader = compile vs_2_0 vs_guassian();
		pixelshader  = compile ps_2_0 ps_guassian();
	}
}