uniform float offset;
uniform sampler2D T0;
uniform float garblefactor;
varying vec2 screenPosition;
uniform float fuglyness;
// varying vec3 color;

void main(void)
{
  vec3 rayStart = vec3(screenPosition, 0.0);
  vec2 moddedScreenPosition =
    vec2( cos(screenPosition.x * 3.1415 * 4.0),
          sin(screenPosition.y * 3.1415 * 4.0));

  moddedScreenPosition = screenPosition;


  vec3 rayDirection = normalize( vec3(moddedScreenPosition,1));
  vec3 accumColor = vec3(0.0 ,0.0, 0.0);


  rayStart.z += offset;

  float r = 1.0;

  {
    float a = rayDirection.x*rayDirection.x + rayDirection.y*rayDirection.y;
    float b = 2.0 * (rayStart.x*rayDirection.x + rayStart.y*rayDirection.y);
    float c = rayStart.x*rayStart.x + rayStart.y*rayStart.y - r*r;

    float d = b*b - 4.0*a*c;
    float maxt = (-b + sqrt(d)) / (2.0*a);

    if (maxt >= 0.0) {

      vec3 intersection = rayStart + rayDirection * maxt;



      float f = intersection.z*.1;
      vec2 texCoord = vec2(f,
        offset*.061 + atan(intersection.y, intersection.x) / 3.14115926535);
      texCoord.x += sin(texCoord.y*3.14*3.0)*fuglyness+1.0;
      texCoord.y += cos(offset*.2+f);
      float factor = (1.0-maxt*.04);

      //if (factor > .4) {
        vec3 texel =texture2D(T0, texCoord).xyz;
        accumColor = texel * .4 * (1.0-maxt*.04);
      //}
    }
  }
  gl_FragColor.rgb = accumColor;
}
