/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Cursor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.AWTUtil;
import org.lwjgl.opengl.AbstractAWTInput;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.WindowsDirectInput;
import org.lwjgl.opengl.WindowsDisplay;
import org.lwjgl.opengl.WindowsKeyboard;
import org.lwjgl.opengl.WindowsMouse;
import org.lwjgl.opengl.WindowsPeerInfo;

final class WindowsAWTInput
extends AbstractAWTInput {
    private static final int WS_CHILD = 0x40000000;
    private final Cursor blank_cursor;
    private Cursor cached_cursor;
    private long cached_hwnd;
    private WindowsMouse cached_mouse;
    private WindowsKeyboard cached_keyboard;
    private boolean has_grabbed;

    public WindowsAWTInput(AWTGLCanvas canvas) throws LWJGLException {
        super(canvas);
        int w = AWTUtil.getMinCursorSize();
        int h = AWTUtil.getMinCursorSize();
        this.blank_cursor = AWTUtil.createCursor(w, h, 0, 0, 1, BufferUtils.createIntBuffer(w * h), null);
    }

    public synchronized void destroy() {
        super.destroy();
        if (this.cached_mouse != null) {
            this.grab(false);
            this.cached_mouse.destroy();
        }
    }

    public synchronized void processInput(PeerInfo peer_info) {
        WindowsPeerInfo windows_peerinfo = (WindowsPeerInfo)peer_info;
        long hwnd = windows_peerinfo.getHwnd();
        try {
            hwnd = WindowsAWTInput.findTopLevelWindow(hwnd);
            if (this.cached_mouse == null || hwnd != this.cached_hwnd) {
                this.has_grabbed = false;
                this.cached_hwnd = hwnd;
                if (this.cached_mouse != null) {
                    this.cached_mouse.destroy();
                }
                WindowsDirectInput dinput = WindowsDisplay.createDirectInput();
                this.cached_mouse = new WindowsMouse(dinput, hwnd);
                this.cached_keyboard = new WindowsKeyboard(dinput, hwnd);
            }
            if (this.isGrabbed() && this.getCanvas().getCursor() != this.blank_cursor) {
                this.cached_cursor = this.getCanvas().getCursor();
                this.getCanvas().setCursor(this.blank_cursor);
            }
            this.grab(this.isGrabbed());
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Failed to create windows mouse: " + e);
        }
    }

    private static native int getWindowStyles(long var0) throws LWJGLException;

    private static native long getParentWindow(long var0);

    private static long findTopLevelWindow(long hwnd) throws LWJGLException {
        int window_styles = WindowsAWTInput.getWindowStyles(hwnd);
        while ((window_styles & 0x40000000) != 0) {
            hwnd = WindowsAWTInput.getParentWindow(hwnd);
            window_styles = WindowsAWTInput.getWindowStyles(hwnd);
        }
        return hwnd;
    }

    private void grab(boolean grab) {
        if (this.has_grabbed != grab) {
            this.cached_mouse.grab(grab);
            this.has_grabbed = grab;
            if (!grab) {
                this.getCanvas().setCursor(this.cached_cursor);
            }
        }
    }

    public synchronized void grabMouse(boolean grab) {
        if (grab != this.isGrabbed()) {
            super.grabMouse(grab);
            if (this.cached_mouse != null && !grab) {
                this.grab(grab);
            }
        }
    }

    public synchronized void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        if (this.isGrabbed()) {
            if (this.cached_mouse != null) {
                this.cached_mouse.poll(coord_buffer, buttons);
            }
        } else {
            super.pollMouse(coord_buffer, buttons);
        }
    }

    public synchronized void readMouse(ByteBuffer buffer) {
        if (this.isGrabbed()) {
            if (this.cached_mouse != null) {
                this.cached_mouse.read(buffer);
            }
        } else {
            super.readMouse(buffer);
        }
    }

    public synchronized void readKeyboard(ByteBuffer buffer) {
        if (this.isGrabbed()) {
            if (this.cached_keyboard != null) {
                this.cached_keyboard.read(buffer);
            }
        } else {
            super.readKeyboard(buffer);
        }
    }

    public synchronized void pollKeyboard(ByteBuffer keyDownBuffer) {
        if (this.isGrabbed()) {
            if (this.cached_keyboard != null) {
                this.cached_keyboard.poll(keyDownBuffer);
            }
        } else {
            super.pollKeyboard(keyDownBuffer);
        }
    }
}

