; ggn[at]atari[dot]org/KUA/Turbo Assembler/Outline/Psycho bee!
; Started  24/3/05 10:16 (approx)
; Finished 23/3/05 15:08 (hopefully!)
; Rev.2 started  23/3/05 22:00 (more or less) - better in everything :)
; Rev.2 finished 23/5/05 23:52 (hopefully for a second time :)))

                IFEQ 0
                OPT X+
                pea     start(PC)
                move.w  #$26,-(SP)
                trap    #14
                addq.l  #6,SP
                rts
start:          clr.b   $FFFF8260.w
                ENDC

; plane/color 0 1 2 3 4 5 6 7 8 9 A B C D E F
;          0  o x o x o x o x o x o x o x o x
;          1  o o x x o o x x o o x x o o x x
;          2  o o o o x x x x o o o o x x x x
;          3  o o o o o o o o x x x x x x x x

                lea     $FFFF8242.w,A0
                moveq   #6,D0
pal:            move.l  #$0FFF,(A0)+
                dbra    D0,pal
;explaination: 1st plane=display plane
;              2nd plane=copy plane (invisible!)
;              3rd plane=display plane (invisible too :)
;(was that an explaination???)

                pea     cls(PC)         ;clear the screen (for tos 2.06)
                move.w  #9,-(SP)
                trap    #1

                move.w  #2,-(SP)        ;get phys address
                trap    #14
                addq.l  #2+6,SP         ;2 ADDs in 1 :)

                movea.l D0,A0
                lea     48+35*160(A0),A0
                movea.l A0,A6           ;a6=phys adress (always!)

                lea     drawlogo4(PC),A4 ;for eori below

                lea     gfx(PC),A1
                moveq   #14,D7          ;d7=lines to process
drawlogo:       move.w  (A1)+,D0        ;get h-line pixels
                moveq   #0,D1           ;d1=current line draw offset
                moveq   #15,D4          ;d4=pixels left to draw for current line
drawlogo2:      lsl.w   #1,D0           ;draw pixel (8x8 pixels on screen=1 src pixel)?
                bcc.s   drawlogo4       ;nope skip drawing

                moveq   #7,D2           ;d2=bytes to draw
                move.w  D1,D3
drawlogo3:      st      0(A0,D3.w)
                st      4(A0,D3.w)      ;put the same into plane 3
                add.w   #160,D3
                dbra    D2,drawlogo3

drawlogo4:      addq.w  #1,D1           ;point to next pixel on screen
                eori.b  #%1100,(A4)     ;wicked smc shit!
                dbra    D4,drawlogo2

drawlogo99:     lea     8*160(A0),A0    ;point to next line
                dbra    D7,drawlogo

BLiTTER         EQU $FFFF8A20
Src_Xinc        EQU 32-32
Src_Yinc        EQU 34-32
Src_Addr        EQU 36-32
Endmask1        EQU 40-32
Endmask2        EQU 42-32
Endmask3        EQU 44-32
Dst_Xinc        EQU 46-32
Dst_Yinc        EQU 48-32
Dst_Addr        EQU 50-32
X_Count         EQU 54-32
Y_Count         EQU 56-32
HOP             EQU 58-32
OP              EQU 59-32
Line_Num        EQU 60-32
Skew            EQU 61-32

ylines          EQU 160

                lea     BLiTTER+Src_Xinc.w,A2
                movem.l blitterdata(PC),D0-D7 ;load blitter data
                movem.l D0-D7,(A2)      ;put data in blitter

                lea     -8-16*160(A6),A6
                lea     2(A6),A5        ;see below
                lea     4(A6),A1        ;point to plane 3!!!
                lea     160(A1),A4      ;see below
                lea     -160(A1),A3     ;see below

                moveq   #99,D1          ;wait 2 sec (on 50hz)
                bra.s   vs

mainloop:
                move.b  #18,$FFFFFC02.w ;turn mouse off

                moveq   #2,D1
vs:             move.w  #37,-(SP)       ;vsync
                trap    #14
                addq.l  #2,SP
                dbra    D1,vs

;step 1: copy graphic from plane 3 to plane 1
s1:             move.b  #3,OP(A2)       ;copy source
                clr.b   Skew(A2)        ;no skew

                lea     4(A6),A1        ;vsync sucks :(
                move.l  A1,Src_Addr(A2) ;set source address=plane 1
                move.l  A6,Dst_Addr(A2) ;set dest address=plane 2
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!

;step 2: make a copy of the graphic in plane 2

                move.l  A6,Src_Addr(A2) ;set source address=plane 1
                move.l  A5,Dst_Addr(A2) ;set dest address=plane 2
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!

;step 3: OR plane 2 into plane 3 (1 pixel to the right & down)
s5:
                move.b  #1,Skew(A2)     ;1 pixel right skew (+NFSR???)
                move.l  A5,Src_Addr(A2) ;source address=plane 2
                move.l  A4,Dst_Addr(A2)
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!

;step 4: OR plane 2 into plane 3 (1 pixel to the right & up)
s6:             move.l  A5,Src_Addr(A2) ;source address=plane 2
                move.l  A3,Dst_Addr(A2)
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!

;step 5: OR plane 2 into plane 3 (1 pixel to the left & up)
s8:             move.b  #-1,Skew(A2)    ;1 pixel left skew (+NFSR???)
                move.l  A5,Src_Addr(A2) ;source address=plane 2
                move.l  A3,Dst_Addr(A2)
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!

;step 6: OR plane 2 into plane 3 (1 pixel to the left & down)
s9:             move.l  A5,Src_Addr(A2) ;source address=plane 2
                move.l  A4,Dst_Addr(A2)
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!

;step 7: XOR plane 2 into plane 3 (original position!)
s10:            move.b  #6,OP(A2)       ;source xor destination
                clr.b   Skew(A2)        ;no skew
                move.l  A5,Src_Addr(A2) ;set source address=plane 1
                move.l  A1,Dst_Addr(A2) ;set dest address=plane 2
                move.w  #ylines,Y_Count(A2) ;y lines
                move.b  #192,Line_Num(A2) ;blit!



                cmpi.b  #57,$FFFFFC02.w ;space pressed?
                bne     mainloop

                move.b  #8,$FFFFFC02.w

                rts

cls:                                    ;dc.b 27,'E',0 ;clears the screen using vt52
                DC.B 27,'E'
                DC.B 'KA software productions: Atari or buST!'
;                     1234567890123456789012345678901234567890
blitterdata:    DC.W 8          ;sxinc
                DC.W 8+80       ;syinc
                DC.L 0          ;saddr
                DC.L $FFFFFFFF  ;endmask1,2
                DC.W $FFFF      ;endmask3
                DC.W 8          ;dxinc
                DC.W 8+80       ;dyinc
                DC.L 0          ;daddr
                DC.W 10         ;xcount
                DC.W 160        ;ycount
                DC.B 2          ;hop
                DC.B 6          ;op (xor!)
                DC.B 0          ;line number
                DC.B 1          ;skew
                DS.W 1          ;pad for 32 bytes


gfx:            DC.W %100000000000
                DC.W %100000111100
                DC.W %1100010
                DC.W %11011000010
                DC.W %1100011010000100
                DC.W %1100110001010
                DC.W %1101100010100
                DC.W %11011100000
                DC.W %1110101011000
                DC.W %11001111111100
                DC.W %110000101100000
                DC.W %100001011011110
                DC.W %100010011011000
                DC.W %100101001010110
                DC.W %11010000010100
;       dc.w %0000000000000000  ;last line not needed ;)


                END
