/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import com.sun.kvem.DeviceConfiguration;
import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.CameraPlayer;
import com.sun.mmedia.MIDIPlayer;
import com.sun.mmedia.MidiTonePlayer;
import com.sun.mmedia.Mime;
import com.sun.mmedia.VideoPlayer2;
import com.sun.mmedia.protocol.BasicDS;
import com.sun.mmedia.protocol.CommonDS;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.SystemTimeBase;
import javax.microedition.media.TimeBase;
import javax.microedition.media.protocol.DataSource;

public final class Manager {
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    public static final String MIDI_DEVICE_LOCATOR = "device://midi";
    private static String DS_ERR = "Cannot create a DataSource for: ";
    private static final String VIDEO_CAPTURE_LOCATOR = "capture://video";
    private static String PL_ERR = "Cannot create a Player for: ";
    private static volatile PlayToneThread playToneThread = null;
    private static Object playToneThreadLock = new Object();
    private static Hashtable handlers = new Hashtable();
    private static TimeBase sysTimeBase;

    private static native int nPlayTone(int var0, int var1, int var2);

    private static native int nStopTone(int var0);

    private static native void initMMedia();

    private Manager() {
    }

    public static String[] getSupportedContentTypes(String protocol) {
        if (protocol != null && protocol.equals("file") && !DeviceConfiguration.getDeviceBooleanProperty((String)"mm.protocol.file", (boolean)false)) {
            return new String[0];
        }
        String[] types = Manager.getSupportedContentTypesOrig(protocol);
        if (types != null) {
            int i;
            Vector<String> filtered = new Vector<String>();
            for (i = 0; i < types.length; ++i) {
                String type = types[i];
                boolean keep = true;
                if (type.equals("audio/x-wav")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.wav", (boolean)true);
                } else if (type.equals("audio/midi") || type.equals("audio/sp-midi")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.midi", (boolean)true);
                } else if (type.equals("audio/amr") || type.equals("audio/amr-wb")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.amr", (boolean)false);
                } else if (type.equals("audio/mpeg")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.mp3", (boolean)false);
                } else if (type.equals("video/mpeg")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.video", (boolean)true);
                } else if (type.equals("audio/imelody")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.imy", (boolean)false);
                } else if (type.equals("video/3gpp")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.format.3gp", (boolean)false);
                } else if (type.equals("video/vnd.sun.rgb565")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.supports.video.capture", (boolean)true);
                }
                if (!keep) continue;
                filtered.addElement(type);
            }
            types = new String[filtered.size()];
            for (i = 0; i < filtered.size(); ++i) {
                types[i] = (String)filtered.elementAt(i);
            }
        }
        return types;
    }

    private static String[] getSupportedContentTypesOrig(String protocol) {
        if (protocol == null) {
            return new String[]{"audio/x-tone-seq", "audio/x-wav", "audio/midi", "audio/sp-midi", "image/gif", "video/mpeg", "video/vnd.sun.rgb565", "audio/imelody", "audio/amr", "audio/mpeg", "video/3gpp"};
        }
        if (protocol.equals("device")) {
            return new String[]{"audio/x-tone-seq", "audio/midi"};
        }
        if (protocol.equals("http") || protocol.equals("file")) {
            return new String[]{"audio/x-tone-seq", "audio/x-wav", "audio/midi", "audio/sp-midi", "image/gif", "video/mpeg", "audio/imelody", "audio/amr", "audio/mpeg", "video/3gpp"};
        }
        if (protocol.equals("capture")) {
            return new String[]{"audio/x-wav", "video/vnd.sun.rgb565"};
        }
        return new String[0];
    }

    public static String[] getSupportedProtocols(String content_type) {
        String[] protocols = Manager.getSupportedProtocolsOrig(content_type);
        if (protocols != null) {
            int i;
            Vector<String> filtered = new Vector<String>();
            for (i = 0; i < protocols.length; ++i) {
                String protocol = protocols[i];
                boolean keep = true;
                if (protocol.equals("capture")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.supports.video.capture", (boolean)true) || DeviceConfiguration.getDeviceBooleanProperty((String)"mm.control.capture", (boolean)true);
                } else if (protocol.equals("file")) {
                    keep = DeviceConfiguration.getDeviceBooleanProperty((String)"mm.protocol.file", (boolean)false);
                }
                if (!keep) continue;
                filtered.addElement(protocol);
            }
            protocols = new String[filtered.size()];
            for (i = 0; i < filtered.size(); ++i) {
                protocols[i] = (String)filtered.elementAt(i);
            }
        }
        return protocols;
    }

    private static String[] getSupportedProtocolsOrig(String content_type) {
        if (content_type == null) {
            return new String[]{"device", "http", "file", "capture"};
        }
        if (content_type.equals("audio/x-tone-seq")) {
            return new String[]{"device", "http", "file"};
        }
        if (content_type.equals("audio/x-wav")) {
            return new String[]{"http", "file", "capture"};
        }
        if (content_type.equals("audio/midi")) {
            return new String[]{"http", "file", "device"};
        }
        if (content_type.equals("audio/sp-midi")) {
            return new String[]{"http", "file"};
        }
        if (content_type.equals("image/gif")) {
            return new String[]{"http", "file"};
        }
        if (content_type.equals("video/mpeg")) {
            return new String[]{"http", "file"};
        }
        if (content_type.equals("video/vnd.sun.rgb565")) {
            return new String[]{"capture"};
        }
        if (content_type.equals("audio/imelody") || content_type.equals("audio/amr") || content_type.equals("audio/mpeg") || content_type.equals("video/3gpp")) {
            return new String[]{"http", "file"};
        }
        return new String[0];
    }

    public static Player createPlayer(String locator) throws IOException, MediaException {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        String tmpStr = locator.toLowerCase();
        if (tmpStr.equals(TONE_DEVICE_LOCATOR)) {
            MidiTonePlayer p = new MidiTonePlayer();
            return p;
        }
        if (tmpStr.equals(MIDI_DEVICE_LOCATOR)) {
            MIDIPlayer p = new MIDIPlayer();
            return p;
        }
        if (tmpStr.startsWith(VIDEO_CAPTURE_LOCATOR)) {
            CameraPlayer p = new CameraPlayer(tmpStr, false);
            return p;
        }
        String theProtocol = null;
        int idx = tmpStr.indexOf(58);
        if (idx == -1) {
            throw new MediaException("malformed locator");
        }
        theProtocol = tmpStr.substring(0, idx);
        String[] supported = Manager.getSupportedProtocols(Mime.ext2Mime((String)tmpStr));
        boolean found = false;
        for (int i = 0; i < supported.length; ++i) {
            if (!theProtocol.equals(supported[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new MediaException("Player cannot be created for " + locator);
        }
        DataSource ds = Manager.createDataSource(locator);
        Player pp = null;
        try {
            pp = Manager.createPlayer(ds);
        }
        catch (MediaException ex) {
            ds.disconnect();
            throw ex;
        }
        catch (IOException ex) {
            ds.disconnect();
            throw ex;
        }
        return pp;
    }

    public static Player createPlayer(InputStream stream, String type) throws IOException, MediaException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new MediaException(PL_ERR + "cannot determine the media type");
        }
        type = type.toLowerCase();
        CommonDS ds = new CommonDS();
        ds.setInputStream(stream);
        ds.setContentType(type);
        try {
            return Manager.createPlayer((DataSource)ds);
        }
        catch (IOException ex) {
            throw new MediaException(PL_ERR + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playTone(int note, int duration, int volume) throws MediaException {
        if (note < 0 || note > 127 || duration <= 0) {
            throw new IllegalArgumentException("bad param");
        }
        if (duration == 0 || volume == 0) {
            return;
        }
        int handle = Manager.nPlayTone(note, duration, volume);
        if (handle == 0) {
            throw new MediaException("can't play tone");
        }
        BasicPlayer.notifyPauseListener((String)"Tone");
        Object object = playToneThreadLock;
        synchronized (object) {
            if (playToneThread == null) {
                playToneThread = new PlayToneThread();
            }
            playToneThread.addHandle(handle);
        }
    }

    private static BasicPlayer getPlayerFromType(String type) throws IOException, MediaException {
        String className;
        if (type == null || (className = (String)handlers.get(type)) == null) {
            throw new MediaException(PL_ERR + type);
        }
        BasicPlayer p = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            p = (BasicPlayer)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new MediaException(PL_ERR + e.getMessage());
        }
        return p;
    }

    public static Player createPlayer(DataSource source) throws IOException, MediaException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        source.connect();
        String contentType = source.getContentType();
        if (contentType.equals("video/mpeg")) {
            VideoPlayer2 vp = new VideoPlayer2(contentType);
            vp.setSource(source);
            return vp;
        }
        BasicPlayer p = Manager.getPlayerFromType(contentType);
        p.setSource(source);
        return p;
    }

    private static DataSource createDataSource(String locator) throws IOException, MediaException {
        String className = (String)handlers.get(BasicDS.getProtocol((String)locator));
        if (className == null) {
            throw new MediaException(DS_ERR + locator);
        }
        try {
            Class<?> protoClass = Class.forName(className);
            DataSource source = (DataSource)protoClass.newInstance();
            ((BasicDS)source).setLocator(locator);
            source.connect();
            return source;
        }
        catch (IOException e) {
            throw e;
        }
        catch (MediaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MediaException(DS_ERR + e.getMessage());
        }
    }

    public static TimeBase getSystemTimeBase() {
        if (sysTimeBase == null) {
            sysTimeBase = new SystemTimeBase();
        }
        return sysTimeBase;
    }

    static /* synthetic */ int access$000(int x0) {
        return Manager.nStopTone(x0);
    }

    static /* synthetic */ Object access$100() {
        return playToneThreadLock;
    }

    static /* synthetic */ PlayToneThread access$202(PlayToneThread x0) {
        playToneThread = x0;
        return playToneThread;
    }

    static {
        handlers.put("http", "com.sun.mmedia.protocol.CommonDS");
        handlers.put("file", "com.sun.mmedia.protocol.CommonDS");
        handlers.put("capture", "com.sun.mmedia.protocol.WavCapture");
        handlers.put("audio/x-wav", "com.sun.mmedia.WavPlayer");
        handlers.put("audio/midi", "com.sun.mmedia.MIDIPlayer");
        handlers.put("audio/sp-midi", "com.sun.mmedia.MIDIPlayer");
        handlers.put("audio/x-tone-seq", "com.sun.mmedia.MidiTonePlayer");
        handlers.put("image/gif", "com.sun.mmedia.GIFPlayer");
        handlers.put("image/gif", "com.sun.mmedia.GIFPlayer");
        handlers.put("audio/imelody", "com.sonyericsson.mmedia.iMelodyPlayer");
        handlers.put("audio/amr", "com.sonyericsson.mmedia.AMRPlayer");
        handlers.put("audio/mpeg", "com.sonyericsson.mmedia.AMRPlayer");
        handlers.put("video/mpeg", "com.sonyericsson.mmedia.AMRPlayer");
        handlers.put("video/3gpp", "com.sonyericsson.mmedia.AMRPlayer");
        Manager.initMMedia();
        sysTimeBase = null;
    }
}

