/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public class TerrainScene
extends Effect {
    private static final int rotationIncrement = 10;
    Texture[] terrainTex = new Texture[7];
    Figure terrain;
    Texture[] textures = new Texture[6];
    Figure skyBox;
    Texture envObjTex;
    Figure envObj;
    private static int currentFrame = 0;
    private Vector3D cameraPosition = new Vector3D(400, 360, -400);
    private Vector3D lookAt = new Vector3D(0, -80, 0);
    private Vector3D upVector = new Vector3D(0, 4096, 0);
    private int ROBOT_PERSPECTIVE = 512;
    private int[][] checkPoints = new int[][]{{131, 82}, {85, 83}, {65, 118}, {71, 165}, {111, 175}, {130, 130}, {171, 93}, {204, 160}, {166, 182}, {130, 130}};
    ObjectTransformation terrainTrans;
    ObjectTransformation envObjTrans;
    int rotationX = 100;
    int rotationY = 0;
    int translationZ = 0;
    int translationX = 0;
    int translationY = 0;
    FigureLayout terrainLayout;
    Effect3D effect;
    Effect3D envEff;
    FigureLayout envLayout;
    private Command changeCommand;
    private Command exitCommand;
    private Graphics3D cachedGraphics3D;
    int currentCheckPoint;
    int travelProgress;
    int rotateProgress;
    int[] oldCam = new int[2];
    int[] oldLookat = new int[2];
    int currentTexture;

    public TerrainScene(DemoCanvas canvas) {
        super(canvas);
    }

    public void init(int[] timePoints) {
        int i;
        super.init(timePoints);
        for (i = 0; i < this.checkPoints.length; ++i) {
            this.checkPoints[i][0] = this.checkPoints[i][0] * 4 - 512;
            this.checkPoints[i][1] = this.checkPoints[i][1] * 4 - 512;
        }
        try {
            for (i = 0; i < this.terrainTex.length; ++i) {
                this.terrainTex[i] = this.demo.loadTexture("/optimized/rocksnow" + i + ".bmp", true);
            }
            this.textures[0] = this.demo.loadTexture("/sky_top_8bit.bmp", true);
            this.textures[1] = this.demo.loadTexture("/sky_front_8bit.bmp", true);
            this.textures[2] = this.demo.loadTexture("/sky_left_8bit.bmp", true);
            this.textures[3] = this.demo.loadTexture("/sky_back_8bit.bmp", true);
            this.textures[4] = this.demo.loadTexture("/sky_right_8bit.bmp", true);
            this.textures[5] = this.demo.loadTexture("/sky_top_8bit.bmp", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.terrain = this.demo.loadFigure("/terrain_test1.mbac");
            this.skyBox = this.demo.loadFigure("/terrain_sky.mbac");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain.setTexture(this.terrainTex[this.currentTexture]);
        this.skyBox.setTexture(this.textures);
        this.effect = new Effect3D();
        this.effect.setShadingType(0);
        this.envEff = new Effect3D();
        this.envEff.setShadingType(0);
        this.envEff.setSphereTexture(this.envObjTex);
        this.terrainTrans = new ObjectTransformation();
        this.envObjTrans = new ObjectTransformation();
        this.terrainLayout = new FigureLayout();
        this.terrainLayout.setPerspective(1, 4096, this.ROBOT_PERSPECTIVE - 128);
        this.terrainLayout.setCenter(this.width / 2, this.height / 2);
        this.cameraPosition.setX(this.checkPoints[0][0]);
        this.cameraPosition.setZ(this.checkPoints[0][1]);
        this.lookAt.setX(this.checkPoints[0][0]);
        this.lookAt.setZ(this.checkPoints[0][1]);
        this.oldCam[0] = this.cameraPosition.getX();
        this.oldCam[1] = this.cameraPosition.getZ();
        this.oldLookat[0] = this.lookAt.getX();
        this.oldLookat[1] = this.lookAt.getZ();
        ++this.currentCheckPoint;
    }

    public void doLogic(int msPassed) {
        this.processKeyState();
        this.travelProgress += msPassed;
        int livedFor = this.timePoints[this.currentAppearance + 1] - this.timeToLive;
        if (this.travelProgress > 2000) {
            ++this.currentCheckPoint;
            this.currentCheckPoint %= this.checkPoints.length;
            this.travelProgress = 0;
            this.oldCam[0] = this.cameraPosition.getX();
            this.oldCam[1] = this.cameraPosition.getZ();
            this.oldLookat[0] = this.lookAt.getX();
            this.oldLookat[1] = this.lookAt.getZ();
        } else {
            this.cameraPosition.setX(this.oldCam[0] + (this.checkPoints[this.currentCheckPoint][0] - this.oldCam[0]) * this.travelProgress / 2000);
            this.cameraPosition.setZ(this.oldCam[1] + (this.checkPoints[this.currentCheckPoint][1] - this.oldCam[1]) * this.travelProgress / 2000);
            this.lookAt.setX(this.oldLookat[0] + (-this.oldCam[0] + this.checkPoints[this.currentCheckPoint % this.checkPoints.length][0] - this.oldLookat[0]) * this.travelProgress / 2000);
            this.lookAt.setZ(this.oldLookat[1] + (-this.oldCam[1] + this.checkPoints[this.currentCheckPoint % this.checkPoints.length][1] - this.oldLookat[1]) * this.travelProgress / 2000);
        }
        if ((this.timeToLive + msPassed) / 1000 != this.timeToLive / 1000 && this.currentTexture < this.terrainTex.length && this.timeToLive < 12000) {
            this.terrain.setTexture(this.terrainTex[this.currentTexture++ % this.terrainTex.length]);
        }
        this.terrainTrans.identity();
        this.terrainTrans.setLookAt(this.cameraPosition, this.lookAt, this.upVector);
        this.terrainLayout.setAffineTrans(this.terrainTrans.calculateTransformation());
    }

    public void draw(Graphics g) {
        Graphics3D g3d = this.demo.getGraphics3D();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.width, this.height);
        try {
            g3d.bind(g);
            g3d.renderFigure(this.skyBox, 0, 0, this.terrainLayout, this.effect);
            g3d.flush();
            g3d.renderFigure(this.terrain, 0, 0, this.terrainLayout, this.effect);
            g3d.flush();
            g3d.release(g);
        }
        catch (Throwable h) {
            h.printStackTrace();
        }
    }

    void processKeyState() {
        if (this.demo.upCnt > 0) {
            this.cameraPosition.setZ(this.cameraPosition.getZ() + 10);
            this.translationZ += 20;
            if (this.rotationX > 4096) {
                this.rotationX = 0;
            }
        }
        if (this.demo.downCnt > 0) {
            this.cameraPosition.setZ(this.cameraPosition.getZ() - 10);
            this.translationZ -= 20;
            if (this.rotationX < 0) {
                this.rotationX = 4096;
            }
        }
        if (this.demo.leftCnt > 0) {
            this.cameraPosition.setX(this.cameraPosition.getX() + 10);
            System.out.println(this.cameraPosition.getX());
            this.translationX += 20;
            if (this.rotationY > 4096) {
                this.rotationY = 0;
            }
        }
        if (this.demo.rightCnt > 0) {
            this.cameraPosition.setX(this.cameraPosition.getX() - 10);
            this.translationX -= 20;
            if (this.rotationY < 0) {
                this.rotationY = 4096;
            }
        }
        if (this.demo.fireCnt > 0) {
            this.translationY -= 10;
        }
    }
}

