/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.ActionTable;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Util3D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Figure {
    private int p;
    private Texture[] myTextureArray;
    private Texture myTextureNow;

    private native int makeI(byte[] var1);

    private native void setPos(ActionTable var1, int var2, int var3);

    private native void setPat(int var1);

    private native int NgetNumPattern();

    private static native void initializeClass0();

    private native void finalize();

    public Figure(byte[] b) {
        if (b == null) {
            throw Util3D.npe;
        }
        this.p = this.makeI(b);
        if (this.p == 0) {
            throw Util3D.rue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Figure(String name) throws IOException {
        if (name == null) {
            throw Util3D.npe;
        }
        InputStream ist = null;
        ByteArrayOutputStream bos = null;
        byte[] buf = null;
        try {
            ist = this.getClass().getResourceAsStream(name);
            if (ist == null) {
                throw Util3D.ioe;
            }
            int a = ist.available();
            if (a <= 0) {
                a = 128;
            }
            bos = new ByteArrayOutputStream(a);
            buf = new byte[a];
            a = 0;
            while ((a = ist.read(buf)) > 0) {
                bos.write(buf, 0, a);
            }
            ist.close();
            ist = null;
            bos.close();
            buf = bos.toByteArray();
            bos = null;
            if (buf.length == 0) {
                throw Util3D.ioe;
            }
            this.p = this.makeI(buf);
            if (this.p == 0) {
                throw Util3D.rue;
            }
        }
        finally {
            try {
                if (ist != null) {
                    ist.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            finally {
                ist = null;
                bos = null;
                buf = null;
            }
        }
    }

    public final void dispose() {
        if (this.p == 0) {
            return;
        }
        this.finalize();
        this.p = 0;
    }

    public final void setPosture(ActionTable act, int action, int frame) {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        if (act == null) {
            throw Util3D.npe;
        }
        if (act.p == 0) {
            throw Util3D.rueD;
        }
        if (action < 0 || action >= act.getNumAction()) {
            throw Util3D.iae;
        }
        this.setPos(act, action, frame);
    }

    public final Texture getTexture() {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        return this.myTextureNow;
    }

    public final Texture[] getTextures() {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        return this.myTextureArray;
    }

    public final void setTexture(Texture t) {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        if (t == null) {
            throw Util3D.npe;
        }
        if (t.p == 0) {
            throw Util3D.rueD;
        }
        if (!t.isModel) {
            throw Util3D.iae;
        }
        this.myTextureArray = new Texture[1];
        this.myTextureArray[0] = t;
        this.myTextureNow = t;
    }

    public final void setTexture(Texture[] t) {
        this.setTextures(t);
    }

    public final void setTextures(Texture[] t) {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        if (t == null || t.length == 0) {
            throw Util3D.npe;
        }
        for (int i = 0; i < t.length; ++i) {
            if (t[i] == null) {
                throw Util3D.npe;
            }
            if (t[i].p == 0) {
                throw Util3D.rueD;
            }
            if (t[i].isModel) continue;
            throw Util3D.iae;
        }
        this.myTextureArray = t;
        this.myTextureNow = null;
    }

    public final int getNumTextures() {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        if (this.myTextureArray == null) {
            return 0;
        }
        return this.myTextureArray.length;
    }

    public final void selectTexture(int idx) {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        if (idx < 0 || idx >= this.getNumTextures()) {
            throw Util3D.iae;
        }
        if (this.myTextureArray[idx].p == 0) {
            throw Util3D.rueD;
        }
        this.myTextureNow = this.myTextureArray[idx];
    }

    public final int getNumPattern() {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        return this.NgetNumPattern();
    }

    public final void setPattern(int idx) {
        if (this.p == 0) {
            throw Util3D.rueD;
        }
        this.setPat(idx);
    }

    static {
        Figure.initializeClass0();
    }
}

