/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public class TerrainScene
extends Effect {
    private static final int rotationIncrement = 10;
    Texture[] terrainTex = new Texture[7];
    Figure terrain;
    Texture[] textures = new Texture[6];
    Figure skyBox;
    Texture envObjTex;
    Figure envObj;
    private static int currentFrame = 0;
    private Vector3D ROBOT_POSITION = new Vector3D(0, 100, 900);
    private Vector3D CAMERA_POSITION = new Vector3D(100, 600, 900);
    private Vector3D ROBOT_LOOK = new Vector3D(0, 0, -4096);
    private Vector3D ROBOT_UP = new Vector3D(0, 4096, 0);
    private int ROBOT_PERSPECTIVE = 512;
    ObjectTransformation terrainTrans;
    ObjectTransformation envObjTrans;
    int rotationX = 100;
    int rotationY = 0;
    int translationZ = 0;
    int translationX = 0;
    FigureLayout terrainLayout;
    Effect3D effect;
    Effect3D envEff;
    FigureLayout envLayout;
    MascotCamera mCamera;
    private Command changeCommand;
    private Command exitCommand;
    private Graphics3D cachedGraphics3D;
    int currentTexture;

    public TerrainScene(DemoCanvas canvas) {
        super(canvas);
    }

    public void init(int[] timePoints) {
        super.init(timePoints);
        try {
            for (int i = 0; i < this.terrainTex.length; ++i) {
                this.terrainTex[i] = this.demo.loadTexture("/optimized/rocksnow" + i + ".bmp", true);
            }
            this.textures[0] = this.demo.loadTexture("/sky_top_8bit.bmp", true);
            this.textures[1] = this.demo.loadTexture("/sky_front_8bit.bmp", true);
            this.textures[2] = this.demo.loadTexture("/sky_left_8bit.bmp", true);
            this.textures[3] = this.demo.loadTexture("/sky_back_8bit.bmp", true);
            this.textures[4] = this.demo.loadTexture("/sky_right_8bit.bmp", true);
            this.textures[5] = this.demo.loadTexture("/sky_top_8bit.bmp", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.terrain = this.demo.loadFigure("/terrain_test1.mbac");
            this.skyBox = this.demo.loadFigure("/terrain_sky.mbac");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terrain.setTexture(this.terrainTex[this.currentTexture]);
        this.skyBox.setTexture(this.textures);
        this.effect = new Effect3D();
        this.effect.setShadingType(0);
        this.envEff = new Effect3D();
        this.envEff.setShadingType(0);
        this.envEff.setSphereTexture(this.envObjTex);
        this.terrainTrans = new ObjectTransformation();
        this.envObjTrans = new ObjectTransformation();
        this.terrainLayout = new FigureLayout();
        this.terrainLayout.setPerspective(1, 4096, this.ROBOT_PERSPECTIVE);
        this.terrainLayout.setCenter(this.width / 2, this.height / 2);
        this.mCamera = new MascotCamera(this.ROBOT_POSITION, this.CAMERA_POSITION);
    }

    public void doLogic(int msPassed) {
        this.processKeyState();
        if ((this.timeToLive + msPassed) / 1000 != this.timeToLive / 1000) {
            this.terrain.setTexture(this.terrainTex[this.currentTexture++ % this.terrainTex.length]);
        }
        this.terrainTrans.identity();
        this.terrainTrans.setLookAt(this.ROBOT_POSITION, this.ROBOT_LOOK, this.ROBOT_UP);
        this.terrainTrans.setRotation(this.rotationX, this.rotationY, 0);
        this.terrainTrans.setTranslation(0, this.translationX, this.translationZ);
        this.terrainLayout.setAffineTrans(this.terrainTrans.calculateTransformation());
    }

    public void draw(Graphics g) {
        Graphics3D g3d = this.demo.getGraphics3D();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.width, this.height);
        try {
            g3d.bind(g);
            g3d.renderFigure(this.skyBox, 0, 0, this.terrainLayout, this.effect);
            g3d.flush();
            g3d.renderFigure(this.terrain, 0, 0, this.terrainLayout, this.effect);
            g3d.flush();
            g3d.release(g);
        }
        catch (Throwable h) {
            h.printStackTrace();
        }
    }

    void processKeyState() {
        if (this.demo.upCnt > 0) {
            this.rotationX += 10;
            if (this.rotationX > 4096) {
                this.rotationX = 0;
            }
        }
        if (this.demo.downCnt > 0) {
            this.rotationX -= 10;
            if (this.rotationX < 0) {
                this.rotationX = 4096;
            }
        }
        if (this.demo.leftCnt > 0) {
            this.rotationY += 10;
            if (this.rotationY > 4096) {
                this.rotationY = 0;
            }
        }
        if (this.demo.rightCnt > 0) {
            this.rotationY -= 10;
            if (this.rotationY < 0) {
                this.rotationY = 4096;
            }
        }
        if (this.demo.fireCnt > 0) {
            this.translationZ += 20;
            this.translationX -= 10;
        }
    }
}

