/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.ActionTable;
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Light;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Vector3D;
import javax.microedition.lcdui.Graphics;

public class RobotScene
extends Effect {
    private static final int rotationIncrement = 5;
    private static Texture backgroundTexture;
    private static Texture robotTexture;
    private static Figure backgroundFigure;
    private static Figure robotFigure;
    private static ActionTable robotAction;
    private static int currentFrame;
    private static int robotActionNumber;
    private Vector3D BACKGROUND_POSITION = new Vector3D(0, 0, 450);
    private Vector3D BACKGROUND_LOOK = new Vector3D(0, -500, -4096);
    private Vector3D BACKGROUND_UP = new Vector3D(0, 4096, 0);
    private int BACKGROUND_PERSPECTIVE = 512;
    private Vector3D ROBOT_POSITION = new Vector3D(0, 0, 450);
    private Vector3D ROBOT_LOOK = new Vector3D(0, -500, -4096);
    private Vector3D ROBOT_UP = new Vector3D(0, 4096, 0);
    private int ROBOT_PERSPECTIVE = 512;
    private Vector3D lightDirVec = new Vector3D(-146, 293, 439);
    private int lightDir = 3730;
    private int lightAmbi = 1626;
    private Light backgroundLight = new Light(this.lightDirVec, this.lightDir, this.lightAmbi);
    private AffineTrans backgroundXTrans;
    private AffineTrans backgroundYTrans;
    private AffineTrans backgroundZTrans;
    private AffineTrans backgroundTrans;
    private AffineTrans backgroundVTrans;
    private AffineTrans robotXTrans;
    private AffineTrans robotYTrans;
    private AffineTrans robotZTrans;
    private AffineTrans robotTrans;
    private AffineTrans robotVTrans;
    private int rotationX = 100;
    private int rotationY = 0;
    private FigureLayout backgroundLayout;
    private FigureLayout robotLayout;
    private Effect3D effect;

    public RobotScene(DemoCanvas canvas) {
        super(canvas);
    }

    public void init(int[] timePoints) {
        super.init(timePoints);
        try {
            backgroundTexture = this.demo.loadTexture("/tex_001.bmp", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            backgroundFigure = this.demo.loadFigure("/test_model_haikei.mbac");
            robotFigure = this.demo.loadFigure("/test_model_robo.mbac");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        backgroundFigure.setTexture(backgroundTexture);
        robotFigure.setTexture(backgroundTexture);
        try {
            robotAction = this.demo.loadActionTable("/action_01.mtra");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.effect = new Effect3D();
        this.effect.setShadingType(0);
        this.effect.setLight(this.backgroundLight);
        this.backgroundXTrans = new AffineTrans();
        this.backgroundYTrans = new AffineTrans();
        this.backgroundZTrans = new AffineTrans();
        this.backgroundTrans = new AffineTrans();
        this.backgroundVTrans = new AffineTrans();
        this.robotXTrans = new AffineTrans();
        this.robotYTrans = new AffineTrans();
        this.robotZTrans = new AffineTrans();
        this.robotTrans = new AffineTrans();
        this.robotVTrans = new AffineTrans();
        this.backgroundLayout = new FigureLayout();
        this.backgroundLayout.setPerspective(1, 4096, this.BACKGROUND_PERSPECTIVE);
        this.backgroundLayout.setCenter(this.demo.getWidth() / 2, this.demo.getHeight() / 2);
        this.robotLayout = new FigureLayout();
        this.robotLayout.setPerspective(1, 4096, this.ROBOT_PERSPECTIVE);
        this.robotLayout.setCenter(this.demo.getWidth() / 2, this.demo.getHeight() / 2);
    }

    public void doLogic(int msPassed) {
        this.backgroundXTrans.setIdentity();
        this.backgroundYTrans.setIdentity();
        this.backgroundZTrans.setIdentity();
        this.backgroundTrans.setIdentity();
        this.backgroundXTrans.rotationX(this.rotationX);
        this.backgroundYTrans.rotationY(this.rotationY);
        this.backgroundZTrans.rotationZ(0);
        this.backgroundYTrans.mul(this.backgroundXTrans);
        this.backgroundZTrans.mul(this.backgroundYTrans);
        this.backgroundVTrans.setIdentity();
        this.backgroundVTrans.lookAt(this.BACKGROUND_POSITION, this.BACKGROUND_LOOK, this.BACKGROUND_UP);
        this.backgroundTrans.mul(this.backgroundVTrans, this.backgroundZTrans);
        this.backgroundLayout.setAffineTrans(this.backgroundTrans);
        this.robotXTrans.setIdentity();
        this.robotYTrans.setIdentity();
        this.robotZTrans.setIdentity();
        this.robotTrans.setIdentity();
        this.robotXTrans.rotationX(this.rotationX);
        this.robotYTrans.rotationY(this.rotationY);
        this.robotZTrans.rotationZ(0);
        this.robotYTrans.mul(this.robotXTrans);
        this.robotZTrans.mul(this.robotYTrans);
        this.robotVTrans.setIdentity();
        this.robotVTrans.lookAt(this.ROBOT_POSITION, this.ROBOT_LOOK, this.ROBOT_UP);
        this.robotTrans.mul(this.robotVTrans, this.robotZTrans);
        this.robotLayout.setAffineTrans(this.robotTrans);
        if ((currentFrame += robotAction.getNumFrames(0) / 30) > robotAction.getNumFrames(0)) {
            currentFrame = 0;
        }
        robotFigure.setPosture(robotAction, 0, currentFrame);
    }

    public void draw(Graphics g) {
        Graphics3D g3d = this.demo.getGraphics3D();
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.demo.getWidth(), this.demo.getHeight());
        try {
            g3d.bind(g);
            g3d.renderFigure(backgroundFigure, 0, 0, this.backgroundLayout, this.effect);
            g3d.renderFigure(robotFigure, 0, 0, this.robotLayout, this.effect);
            g3d.flush();
            g3d.release(g);
        }
        catch (Throwable h) {
            h.printStackTrace();
        }
        g.setColor(0);
        g.fillRect(0, 0, this.width, 20);
        g.setColor(0xFFFFFF);
        g.drawString(this.demo.lastTime - this.demo.startTime + ", " + this.demo.app.player.getMediaTime() / 1000L, 0, 0, 20);
    }

    static {
        currentFrame = 0;
        robotActionNumber = 1;
    }
}

