/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.ActionTable;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Player;

public class DemoCanvas
extends GameCanvas
implements CommandListener {
    public static int[] frameBuffer;
    public static int[] backBuffer;
    public Vector effects;
    public long lastTime;
    public long startTime;
    int timePassed;
    public Graphics g;
    public boolean commitFrameBuffer;
    public Random rand = new Random();
    public PerkeleDemo app;
    private Command changeCommand;
    private Command exitCommand;
    private Graphics3D cachedGraphics3D;
    int framesDrawn;
    public int upCnt;
    public int downCnt;
    public int leftCnt;
    public int rightCnt;
    public int fireCnt;

    DemoCanvas(PerkeleDemo app) {
        super(false);
        this.setFullScreenMode(true);
        this.app = app;
        this.effects = new Vector();
        frameBuffer = new int[this.getWidth() * this.getHeight()];
        backBuffer = new int[this.getWidth() * this.getHeight()];
        this.g = this.getGraphics();
        this.exitCommand = new Command("Quit", 7, 1);
        this.addCommand(this.exitCommand);
        this.setCommandListener(this);
        EphScene l = new EphScene(this);
        l.init(new int[]{0, 20000});
        this.effects.addElement(l);
        Image overlay = null;
        try {
            overlay = Image.createImage((String)"/moomin/eph-moomin.png");
        }
        catch (Exception e) {
            System.out.println("could not set up overlay");
            e.printStackTrace();
        }
        Overlay ephMoomin = new Overlay(this);
        ephMoomin.init(new int[]{400, 5000, 7000, 4000, 12000, 4000, 16000, 4000}, overlay, 0, this.getHeight() - overlay.getHeight(), 0);
        this.effects.addElement(ephMoomin);
        this.startTime = Long.MAX_VALUE;
        this.lastTime = System.currentTimeMillis();
    }

    public Graphics3D getGraphics3D() {
        if (this.cachedGraphics3D == null) {
            this.cachedGraphics3D = new Graphics3D();
        }
        return this.cachedGraphics3D;
    }

    synchronized void processFrame() {
        if (this.startTime > this.lastTime) {
            this.startTime = System.currentTimeMillis();
        }
        this.timePassed = (int)(System.currentTimeMillis() - this.lastTime);
        this.lastTime = System.currentTimeMillis();
        this.commitFrameBuffer = false;
        this.g.setColor(0);
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int drawnEffects = 0;
        for (int i = 0; i < this.effects.size(); ++i) {
            Effect e = (Effect)this.effects.elementAt(i);
            if (!e.shouldExecute(this.timePassed, (int)this.totalTimeElapsed())) continue;
            e.doLogic(this.timePassed);
            e.draw(this.g);
            if (this.commitFrameBuffer) {
                this.g.drawRGB(frameBuffer, 0, this.getWidth(), 0, 0, this.getWidth(), this.getHeight(), false);
                this.commitFrameBuffer = false;
            }
            ++drawnEffects;
        }
        this.fireCnt = 0;
        this.rightCnt = 0;
        this.leftCnt = 0;
        this.downCnt = 0;
        this.upCnt = 0;
        if (drawnEffects == 0) {
            return;
        }
        ++this.framesDrawn;
        this.g.setColor(65535);
        this.g.drawString("" + (long)(this.framesDrawn * 1000) / this.totalTimeElapsed(), 0, 0, 20);
        this.flushGraphics();
    }

    public Figure loadFigure(String fileName) throws Exception {
        return new Figure(fileName);
    }

    public long totalTimeElapsed() {
        Player cfr_ignored_0 = this.app.player;
        if (this.app.player.getState() != 400) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.app.player.getMediaTime() / 1000L;
    }

    public ActionTable loadActionTable(String fileName) throws Exception {
        return new ActionTable(fileName);
    }

    public Texture loadTexture(String fileName, boolean noSphere) throws Exception {
        return new Texture(fileName, noSphere);
    }

    public void processKeyStates() {
        int keyCode = this.getKeyStates();
        if ((keyCode & 2) != 0) {
            ++this.upCnt;
        } else if ((keyCode & 0x40) != 0) {
            ++this.downCnt;
        } else if ((keyCode & 4) != 0) {
            ++this.leftCnt;
        } else if ((keyCode & 0x20) != 0) {
            ++this.rightCnt;
        } else if ((keyCode & 0x100) != 0) {
            ++this.fireCnt;
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.app.destroyApp(true);
        }
    }
}

