package org.boozembly;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.view.View;

import java.util.Map;

/** View for rendering graphics, playing sound 
 *
 * boozembly 04 invitation.  adapted for android in november 2007.
 *
 * @author jmagic@komplex.org
 */
public class Booze04View extends View
{
    Drawable bg;
    Drawable text;
    Drawable damage;

    int frames;

    final static int[] textH = {0, 128, 236, 348, 452, 541, 620, 680, 730, 830, 830};
    final static int textCount = 13;
    final static int[] ordnung = {9, 0, 1, 2, 4, 5, 6, 2, 7, 8, 9, 3, 9};

    int xrnd = 0, yrnd = 0;
    int xrnd2, yrnd2;

    long t0, t1;

    MediaPlayer mp;

    public Booze04View(Context context, AttributeSet attributeSet, Map map)
    {
        super(context, attributeSet, map);

        bg = context.getResources().getDrawable(R.drawable.bg);
        text = context.getResources().getDrawable(R.drawable.boozetext2);
        damage = context.getResources().getDrawable(R.drawable.damage);

        mp = MediaPlayer.create(context, R.raw.loop);
        mp.setLooping(1);
        mp.prepare();

        t0 = System.currentTimeMillis();
    }

    boolean active;

    public void pause()
    {
        active = false;
        mp.pause();
    }

    public void resume()
    {
        active = true;
        mp.start();
        invalidate();
    }

    protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);    //To change body of overridden methods use File | Settings | File Templates.
        int t = (int) ((System.currentTimeMillis() - t0) / 10L);

        int w = Math.min(256, canvas.getClipBounds().width());//g.getClipWidth();
        int h = canvas.getClipBounds().height();//g.getClipHeight();

        float s = canvas.getClipBounds().width() * 1.0f / w;

        int y = (int) ((h / s - 128)) / 2;
        canvas.translate(0, y);
        canvas.clipRect(0, 0, canvas.getBitmapWidth(), 128 * s);
        canvas.scale(s, s);

        int x = w / 2 - 176;

        // business logic
        int offset = 0;

        int wb = (bg.getIntrinsicWidth()/*bg.getWidth(null)*/ - w);
        if (wb > 0)
        {
            offset = t / 5;
            int cnt = offset / wb;
            offset = offset % wb;
            if ((cnt & 1) != 0) offset = wb - offset;
        }

        int idx = (t / 400) % textCount;
        idx = ordnung[idx];

        int xt = w / 2 - 64;
        int ht = textH[idx + 1] - textH[idx];

        int yoff = (128 - ht) / 2;

        if ((t & 15) < 8)
        {
            xrnd = (7 * xrnd + ((frames * frames & 15) - 8)) >> 3;
            yrnd = (3 * yrnd + ((frames * frames * frames & 15) - 8)) >> 2;
        }

        int y1 = yrnd + yoff;
        int y2 = y1 + ht;
        if (y1 < 0) y1 = 0;
        if (y2 > 128) y2 = 128;

        //if((t&0x16)==0x10)
        {
            xrnd2 = (xrnd2 * 15 + (((frames + 5) * frames & 63))) >> 4;
            yrnd2 = (yrnd2 * 7 + ((frames * frames * frames * (frames + 3) & 127))) >> 3;
        }

        // background
        canvas.translate(-offset, 0);
        bg.setBounds(0, 0, bg.getIntrinsicWidth(), bg.getIntrinsicHeight());
        bg.draw(canvas);
        canvas.translate(offset, 0);

        // damage
        canvas.translate(-xrnd2, -yrnd2);
        damage.setBounds(0, 0, damage.getIntrinsicWidth(), damage.getIntrinsicHeight());

        damage.draw(canvas);
        canvas.translate(damage.getIntrinsicWidth(), 0);
        damage.draw(canvas);
        canvas.translate(-damage.getIntrinsicWidth(), 0);
        canvas.translate(xrnd2, yrnd2);

        // text
        canvas.clipRect(0, y1, canvas.getBitmapWidth(), y2);
        canvas.translate(xt + xrnd, yrnd + yoff - textH[idx]);

        text.setBounds(0, 0, text.getIntrinsicWidth(), text.getIntrinsicHeight());
        text.draw(canvas);

        canvas.translate(-(xt + xrnd), -(yrnd + yoff - textH[idx]));

        if (active)
        {
            frames++;
            invalidate();
        }
    }
}
