; VARIABLES :
;=============

random_nbr dd 43212



InitMem:
  Call GetSeg
  jc GlobalError
  mov [t_angles],ax
  call GetSeg
  jc GlobalError
  mov [t_depths],ax
  call GetSeg
  jc GlobalError
  mov [virt],ax
  call GetSeg
  jc GlobalError
  mov [plasma],ax
  call GetSeg
  jc GlobalError
  mov [virt2],ax
  call GetSeg
  jc GlobalError
  mov [enviro],ax
  call GetSeg
  jc GlobalError
  mov [mplasma],ax
ret



GlobalError:
  int 20h



; GetSeg
;========
; Desc     : Alloue 1 segment de mem
; Entres  : /
; Modifis : BX
; Retour   : AX = adresse du segment. CF = 1 si erreur
GetSeg:
  mov ah,48h
  mov bx,4096
  int 21h
ret


; ClearSeg
;==========
; Desc     : Efface un segment
; Entres  : ES : le segment, AX : la couleur
; Modifis : DI=0, CX=0
; Retour   : /
ClearSeg:
  xor di,di
  mov cx,65536/2
  rep stosw
ret


; CopySeg
;=========
; Desc     : Copie un segment
; Entres  : DS, ES = sources et destination
; Modifis : CX=0, SI=0, DI=0
; Retour   : /
CopySeg:
  xor di,di
  xor si,si
  mov cx,65536/2
  rep movsw
ret

;huit_3 db 128,128,128,128,128,128,128,128
; Entres : ES=source/dest
;DecreaseSeg:
;  movq mm1,[huit_3]
;  xor di,di
;  mov cx,65536/8
;  .ds_loop:
;    movq mm0,[es:di]
;    psubusb mm0,mm1
;    movq [es:di],mm0
;    add di,8
;  loop .ds_loop
;  emms
;ret

Random:
  push edx
  mov eax,[cs:random_nbr]
  mov edx,69069
  imul eax,edx
  mov [cs:random_nbr],eax
  pop edx
ret


Fin_Tout:
  call StopTimer
  mov ax,3
  int 10h
  int 20h