#pragma once
#include "maths.h"

#define kPhysicsTimeStep (1.0f/60.0f)

void PhysicsInit();
void PhysicsSim(float t);
void PhysicsRender();
void PhysicsMoveFloor(float howMuch);
void PhysicsSelectFloorHex(int which);

#if !FINALBUILD
void PhysicsSeekToTime(int tseconds);
#endif


// return object point range: higher 16 bits is start index, lower 16 bits is point count
unsigned PhysicsAddCube(float x, float y, float z, float halfSize, bool birdCube);
unsigned PhysicsAddStickPerson(float x, float y, float z, float halfSize);

void PhysicsObjectEnable(unsigned pointStartAndCount, bool enable);

// default bounds
const float kMinX = -4;
const float kMinY = -1;
const float kMinZ = -4;
const float kMaxX = 4;
const float kMaxY = 2;
const float kMaxZ = 4;
