
// #include <math.h>
#include <windows.h>
#include <d3d8.h>

#include "fmath.h"
#include "d3du8.h"

// ------------------------------------------------------------------------------------------------
//  Vector Math.
// ------------------------------------------------------------------------------------------------

// --- Create Vector.
/*
D3DVECTOR *D3DUVec3Create( D3DVECTOR *pOut, FLOAT x, FLOAT y, FLOAT z )
  {
    pOut->x = x;
    pOut->y = y;
    pOut->z = z;
    return pOut;
   }

D3DVECTOR *D3DUVec3Copy( D3DVECTOR *pOut, D3DVECTOR *pIn )
  {
    pOut->x = pIn->x;
    pOut->y = pIn->y;
    pOut->z = pIn->z;
    return pOut;
   }

D3DVECTOR *D3DUVec3Add( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 )
  {
    pOut->x = pV1->x + pV2->x;
    pOut->y = pV1->y + pV2->y;
    pOut->z = pV1->z + pV2->z;
    return pOut;
   }

D3DVECTOR *D3DUVec3Sub( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 )
  {
    pOut->x = pV1->x - pV2->x;
    pOut->y = pV1->y - pV2->y;
    pOut->z = pV1->z - pV2->z;
    return pOut;
   }

D3DVECTOR *D3DUVec3Cross( D3DVECTOR *pOut, D3DVECTOR *pV1, D3DVECTOR *pV2 )
  {
    D3DVECTOR Vec;
    Vec.x = pV1->y * pV2->z - pV1->z * pV2->y;
    Vec.y = pV1->z * pV2->x - pV1->x * pV2->z;
    Vec.z = pV1->x * pV2->y - pV1->y * pV2->x;
    return D3DUVec3Copy( pOut, &Vec );
   }

FLOAT __stdcall D3DUVec3Dot( D3DVECTOR *pV1, D3DVECTOR *pV2 )
  {
    return ( pV1->x * pV2->x + pV1->y * pV2->y + pV1->z * pV2->z );
   }

FLOAT D3DUVec3LengthSq( D3DVECTOR *pV )
  {
    return (FLOAT) ( pV->x * pV->x + pV->y * pV->y + pV->z * pV->z );
   }

FLOAT D3DUVec3Length( D3DVECTOR *pV )
  {
    return (FLOAT) fsqrt( pV->x * pV->x + pV->y * pV->y + pV->z * pV->z );
   }

D3DVECTOR *D3DUVec3Normalize( D3DVECTOR *pOut, D3DVECTOR *pV )
  {
    FLOAT Len = D3DUVec3Length( pV );
    D3DUVec3Copy( pOut, pV );
    if ( Len )
      {
        pOut->x /= Len;
        pOut->y /= Len;
        pOut->z /= Len;
       }
    return pOut;
   }
*/

// ------------------------------------------------------------------------------------------------
//  Matrix Math.
// ------------------------------------------------------------------------------------------------

// --- Constant Identity Matrix.
D3DMATRIX D3DUMatrixIdentity = 
  {
    1.0f, 0.0f, 0.0f, 0.0f,
    0.0f, 1.0f, 0.0f, 0.0f,
    0.0f, 0.0f, 1.0f, 0.0f,
    0.0f, 0.0f, 0.0f, 1.0f
   };
/*
D3DMATRIX *D3DUMatrixCopy( D3DMATRIX *pOut, D3DMATRIX *pM )
  {
    int I, J;
    for ( I=0; I<4; I++ )
      for ( J=0; J<4; J++ )
        pOut->m[I][J] = pM->m[I][J];
    return pOut;
   }

D3DMATRIX *D3DUMatrixMultiply( D3DMATRIX *pOut, D3DMATRIX *pM1, D3DMATRIX *pM2 )
  {
    D3DMATRIX Mat;
    FLOAT M1_I0, M1_I1, M1_I2, M1_I3;
    INT I;

    for ( I=0; I<4; I++ )
      {
        M1_I0 = pM1->m[0][ I ];
        M1_I1 = pM1->m[1][ I ];
        M1_I2 = pM1->m[2][ I ];
        M1_I3 = pM1->m[3][ I ];
        Mat.m[0][ I ] = M1_I0 * pM2->_11 + M1_I1 * pM2->_21 +M1_I2 * pM2->_31 +M1_I3 * pM2->_41;
        Mat.m[1][ I ] = M1_I0 * pM2->_12 + M1_I1 * pM2->_22 +M1_I2 * pM2->_32 +M1_I3 * pM2->_42;
        Mat.m[2][ I ] = M1_I0 * pM2->_13 + M1_I1 * pM2->_23 +M1_I2 * pM2->_33 +M1_I3 * pM2->_43;
        Mat.m[3][ I ] = M1_I0 * pM2->_14 + M1_I1 * pM2->_24 +M1_I2 * pM2->_34 +M1_I3 * pM2->_44;
       }
    return D3DUMatrixCopy( pOut, &Mat );
   }

// --- Create Translation Matrix.
D3DMATRIX *D3DUMatrixTranslation( D3DMATRIX *pOut, FLOAT x, FLOAT y, FLOAT z )
  {
    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
    pOut->_41 = x;
    pOut->_42 = y;
    pOut->_43 = z;
    return pOut;
   }

// --- Create X-Axis Rotation Matrix.

D3DMATRIX *D3DUMatrixRotationX( D3DMATRIX *pOut, FLOAT Angle )
  {
    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
    pOut->_22 = fcos( Angle ); pOut->_23 = fsin( Angle );
    pOut->_32 = -fsin( Angle ); pOut->_33 = fcos( Angle );  
    return pOut;
   }

// --- Create Y-Axis Rotation Matrix.

D3DMATRIX *D3DUMatrixRotationY( D3DMATRIX *pOut, FLOAT Angle )
  {
    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
    pOut->_11 = fcos( Angle ); pOut->_13 = -fsin( Angle );
    pOut->_31 = fsin( Angle ); pOut->_33 = fcos( Angle );  
    return pOut;
   }

// --- Create Z-Axis Rotation Matrix.

D3DMATRIX *D3DUMatrixRotationZ( D3DMATRIX *pOut, FLOAT Angle )
  {
    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
    pOut->_11 = fcos( Angle ); pOut->_12 = fsin( Angle );
    pOut->_21 = -fsin( Angle ); pOut->_22 = fcos( Angle );
    return pOut;
   }

// --- Create Left-Handed Look-At Matrix.

D3DMATRIX *D3DUMatrixLookAtLH( D3DMATRIX *pOut, D3DVECTOR *pEye, D3DVECTOR *pAt, D3DVECTOR *pUp )
  {
    FLOAT Len;
    D3DVECTOR X, Y, Z;
  
    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
 
    D3DUVec3Sub( &Z, pAt, pEye );

    Len = D3DUVec3LengthSq( pEye );

    D3DUVec3Normalize( &Z, &Z );
    D3DUVec3Normalize( &Y, pUp );

    D3DUVec3Cross( &X, &Y, &Z );
    D3DUVec3Cross( &Y, &Z, &X );

    D3DUVec3Normalize( &X, &X );
    D3DUVec3Normalize( &Y, &Y );

    pOut->_11 = X.x; pOut->_21 = X.y; pOut->_31 = X.z;
    pOut->_12 = Y.x; pOut->_22 = Y.y; pOut->_32 = Y.z;
    pOut->_13 = Z.x; pOut->_23 = Z.y; pOut->_33 = Z.z;

    pOut->_41 = -D3DUVec3Dot( &X, pAt );
    pOut->_42 = -D3DUVec3Dot( &Y, pAt );
    pOut->_43 = (FLOAT) fsqrt( Len - pOut->_41 * pOut->_41 - pOut->_42 * pOut->_42 );

    return pOut;
   }

D3DMATRIX *D3DUMatrixPerspectiveFovLH_Old( D3DMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf )
  {
    FLOAT Q = zf / ( zf - zn );
    D3DUMatrixCopy( pOut, &D3DUMatrixIdentity );
    pOut->_11 = fcos( fovy * 0.5f ) / fsin( fovy * 0.5f ) / Aspect;
    pOut->_22 = fcos( fovy * 0.5f ) / fsin( fovy * 0.5f );
    pOut->_33 = Q;
    pOut->_43 = - zn * Q;
    pOut->_34 = 1.0f;
    pOut->_44 = 0.0f;
    return pOut;
   }
*/