/******************************************************************************/
/* MIXER_CLIPCOPY.C                                                           */
/* ----------------                                                           */
/* MiniFMOD public source code release.                                       */
/* This source is provided as-is.  Firelight Multimedia will not support      */
/* or answer questions about the source provided.                             */
/* MiniFMOD Sourcecode is copyright (c) 2000, Firelight Multimedia.           */
/* MiniFMOD Sourcecode is in no way representative of FMOD 3 source.          */
/* Firelight Multimedia is a registered business name.                        */
/* This source must not be redistributed without this notice.                 */
/******************************************************************************/

#include "sound.h"

void FSOUND_MixerClipCopy_Float32(void *dest, void *src, long len)
{
	int count;
	short *destptr = (short *)dest;
	float *srcptr = (float *)src;

	if (len <=0 || !dest || !src) 
		return;

	for (count=0; count<len<<1; count++)
	{
		int val;
		__asm
		{
			mov eax, srcptr
			fld [eax]
			add srcptr, 4
			fistp val
		}
		*destptr++ = (val < -32768 ? -32768 : val > 32767 ? 32767 : val);
	}
		
}
