/******************************************************************************/
/* MINIFMOD.H                                                                 */
/* ----------------                                                           */
/* MiniFMOD public source code release.                                       */
/* This source is provided as-is.  Firelight Multimedia will not support      */
/* or answer questions about the source provided.                             */
/* MiniFMOD Sourcecode is copyright (c) 2000, Firelight Multimedia.           */
/* MiniFMOD Sourcecode is in no way representative of FMOD 3 source.          */
/* Firelight Multimedia is a registered business name.                        */
/* This source must not be redistributed without this notice.                 */
/******************************************************************************/

//==========================================================================================
// MINIFMOD Main header file. Copyright (c), FireLight Multimedia 2000.
// Based on FMOD, copyright (c), FireLight Multimedia 2000.
//==========================================================================================

#ifndef _MINIFMOD_H_
#define _MINIFMOD_H_

#pragma comment( lib, "winmm.lib" )

//===============================================================================================
//= SETTINGS
//= - You may wish to alter these...
//===============================================================================================

// defining can save bytes instead of conditional jumps
//#define __ENABLE_SAMPLELOADCALLBACK__

// this removes most of the checks and memory deallocations
// may cause crashes if the XM is faulty
//#define __ENABLE_EXCEPTION_HANDLING__

// this disables the exceptionhandling for patterns that are in
// the orderlist / samples and
// instruments that are used/assigned, but not stored in the xm.
// i'm not sure if they ever happen but if you don't screw up
// your xm then you won't need this.
//#define __EMPTY_STUFF_EXCEPTION__

//===============================================================================================
//= DEFINITIONS
//===============================================================================================

// fmod defined types
typedef struct FMUSIC_MODULE	FMUSIC_MODULE;

//===============================================================================================
//= FUNCTION PROTOTYPES
//===============================================================================================

#ifdef __cplusplus
extern "C" {
#endif

// ==================================
// Initialization / Global functions.
// ==================================
#ifdef __ENABLE_SAMPLELOADCALLBACK__
typedef void (*SAMPLELOADCALLBACK)(void *buff, int lenbytes, int numbits, int instno, int sampno);
#endif

signed char		FSOUND_Init(int mixrate);
void			FSOUND_Close();

// =============================================================================================
// FMUSIC API
// =============================================================================================

// Song management / playback functions.
// =====================================
#ifdef __ENABLE_SAMPLELOADCALLBACK__
FMUSIC_MODULE * FMUSIC_LoadSong(char *data, int size, SAMPLELOADCALLBACK sampleloadcallback);
#else
FMUSIC_MODULE * FMUSIC_LoadSong(char *data, int size);
#endif

signed char		FMUSIC_FreeSong(FMUSIC_MODULE *mod);
signed char		FMUSIC_PlaySong(FMUSIC_MODULE *mod);
signed char		FMUSIC_StopSong(FMUSIC_MODULE *mod);

// Runtime song information.
// =========================
int				FMUSIC_GetOrder(FMUSIC_MODULE *mod);
int				FMUSIC_GetRow(FMUSIC_MODULE *mod);
unsigned int	FMUSIC_GetTime(FMUSIC_MODULE *mod);
  
#ifdef __cplusplus
}
#endif

#endif
