#include <stdio.h>
#include <math.h>
#include "glClass.h"

#define WIDTH 800
#define HEIGHT 600
#define BPP 32

#define DIE(s) { MessageBox(hWnd,s,"Damn",MB_OK); exit(0); }
//#define DIE(s) { MessageBox(hWnd,"OGL error :)","Damn",MB_OK); exit(0); }
#pragma comment(lib,"opengl32.lib")
#pragma comment(lib,"glu32.lib")


LRESULT CALLBACK WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  switch (uMsg)                 
  {
    case WM_KEYDOWN:
      switch( wParam ) {
        case VK_ESCAPE:
          PostMessage(hWnd, WM_CLOSE, 0, 0);
          break;
      }

    case WM_ACTIVATE: {
      if (!HIWORD(wParam)) glClass::active = 1;
      else glClass::active = 0;
      return 0;
    }

    case WM_SYSCOMMAND: {
      switch (wParam) {
        case SC_SCREENSAVE:         
        case SC_MONITORPOWER:       
        return 0;             
      }
      break;                  
    }

    case WM_CLOSE: {
      glClass::finished = 1;
      return 0;               
    }

  }

  return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

typedef void (APIENTRY * WGLSWAPINTERVALEXT) (int);

glClass::glClass(BYTE fullscreen) {
  WNDCLASS  WC;
  DWORD   wStyle;
  DWORD   wExStyle;

  glClass::active=1;
  glClass::finished=0;

  hWnd = NULL;
  
  // create a window class
  WC.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  WC.lpfnWndProc = WndProc;
  WC.cbClsExtra = 0;
  WC.cbWndExtra = 0;
  WC.hInstance = GetModuleHandle(NULL);
  WC.hIcon = NULL;
  WC.hCursor = LoadCursor(NULL, IDC_ARROW);
  WC.hbrBackground = NULL;
  WC.lpszMenuName = NULL;
  WC.lpszClassName = "muahcls";

  if (!RegisterClass(&WC)) DIE("RegisterClass");
  
  wExStyle = WS_EX_APPWINDOW;
  wStyle = WS_POPUP | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
  if (!fullscreen) wStyle |= WS_OVERLAPPED | WS_CAPTION;// | WS_SYSMENU;

  RECT r;
  r.top = r.left = 0;
  r.bottom = HEIGHT;
  r.right = WIDTH;

  DEVMODE   sSettings;
  unsigned  PixelFormat;
  if (fullscreen) {
    // change display settings
    memset(&sSettings, 0, sizeof(sSettings));
    sSettings.dmSize = sizeof(sSettings);
    sSettings.dmPelsWidth = WIDTH;
    sSettings.dmPelsHeight = HEIGHT;
    sSettings.dmBitsPerPel = BPP;//16;
    sSettings.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
    if (ChangeDisplaySettings(&sSettings, 0) != DISP_CHANGE_SUCCESSFUL)
      DIE("ChangeDisplay");
    ShowCursor(false);
  } else {
    AdjustWindowRectEx(&r,wStyle,false,wExStyle);
  }

  hWnd = CreateWindowEx(wExStyle,"muahcls","",wStyle,
              0,0,WIDTH,HEIGHT,
              NULL,NULL,GetModuleHandle(NULL),NULL);

  if (hWnd == NULL) DIE("CreateWindowEx");

  if (!fullscreen)
    SetWindowPos(hWnd,
#ifdef _DEBUG
                  HWND_TOP,
#else
                  HWND_TOPMOST,
#endif
                 (GetSystemMetrics(SM_CXSCREEN)- WIDTH)/2,
                 (GetSystemMetrics(SM_CYSCREEN)-HEIGHT)/2,
                 r.right-r.left,r.bottom-r.top,SWP_SHOWWINDOW);

  // display window
  ShowWindow(hWnd, SW_SHOW);
  SetForegroundWindow(hWnd);
  SetFocus(hWnd);

  // create device context
  if (!hWnd) DIE("hWnd fucked up");
  if (!(hDC = GetDC(hWnd))) DIE("GetDC");

  // set pixel format
  PIXELFORMATDESCRIPTOR pfd;
  memset(&pfd, 0, sizeof(pfd));
  pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
  pfd.nVersion   = 1;
  pfd.dwFlags    = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
  pfd.iPixelType = PFD_TYPE_RGBA;
  pfd.cColorBits = BPP;//16;
  pfd.cDepthBits = BPP;//16;
  pfd.dwLayerMask = PFD_MAIN_PLANE;

  if (!(PixelFormat = ChoosePixelFormat(hDC, &pfd))) DIE("ChoosePixelFormat"); 
  if (!SetPixelFormat(hDC, PixelFormat, &pfd))       DIE("SetPixelFormat"); 
  if (!(hRC = wglCreateContext(hDC)))                DIE("wglCreateContext");
  if (!wglMakeCurrent(hDC, hRC))                     DIE("wglMakeCurrent");

  glViewport(0, 0, WIDTH, HEIGHT);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45.0, (GLfloat)WIDTH/(GLfloat)HEIGHT, 0.1, 100.0);

  glClearColor(0.0, 0.0, 0.0, 0.0);

  glDepthFunc(GL_LESS);
  glEnable(GL_DEPTH_TEST);

  glDisable(GL_CULL_FACE);

  glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

  glFogf(GL_FOG_MODE,GL_LINEAR);
  GLfloat fog[] = {0,0,0,0};
  glFogfv(GL_FOG_COLOR,fog);
  glFogf(GL_FOG_DENSITY,1.3f);
  glFogf(GL_FOG_START,1);
  glFogf(GL_FOG_END,5);
  glHint(GL_FOG_HINT,GL_FASTEST); 

  WGLSWAPINTERVALEXT wglSwapIntervalEXT = (WGLSWAPINTERVALEXT) wglGetProcAddress("wglSwapIntervalEXT");
  if (wglSwapIntervalEXT) wglSwapIntervalEXT(1); // enable vertical synchronisation

}

glClass::~glClass() {
  DestroyWindow(hWnd);
  ChangeDisplaySettings(NULL,NULL);
}

void glClass::messages() {
  MSG msg;
  if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ) {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
  }
}

void glClass::flip() {
   SwapBuffers(hDC);
}

int glClass::active=1;
int glClass::finished=1;

void glClass::set2D() {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0.0f, 640.0f, 0.0f, 480.0f,-1.0f,1.0f);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

void glClass::set3D(float fov) {
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(fov, -(GLfloat)WIDTH/(GLfloat)HEIGHT, 0.1, 5000.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
}

GLuint glClass::uploadTexture(int width, int height, void * data) {
  GLuint id;
  glGenTextures(1, &id);
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, id);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
  gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA8, width, height, GL_RGBA, GL_UNSIGNED_BYTE, data);
  return id;
}

#pragma pack(1)
typedef struct {
  unsigned char unknown[0x0C];
  unsigned short width;
  unsigned short height;
  unsigned char bpp;
  unsigned char unknown2;
} TGAHEADER;
#pragma pack()

GLuint glClass::uploadTextureFromTGA(char * filename) {
  FILE * f = fopen(filename,"rb");
  TGAHEADER h;
  fread(&h,sizeof(TGAHEADER),1,f);

  unsigned int * image = new unsigned int[h.height*h.width];
  for(int y=0; y<h.height; y++)
    for(int x=0; x<h.width; x++) {
      unsigned char r = 0, g = 0, b = 0;
      fread(&r,1,1,f);
      fread(&g,1,1,f);
      fread(&b,1,1,f);
      image[h.width * y + x] = (g<<16) | (b<<8) | (r<<0);
    }
  GLuint i = uploadTexture(h.width,h.height,image);
  delete[] image;
  return i;
}